/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.dataflow.coders;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.Adapters;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.PutAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Mutation;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;

public class HBaseMutationCoder
extends AtomicCoder<Mutation> {
    private static final long serialVersionUID = -3853654063196018580L;
    private static final PutAdapter PUT_ADAPTER = new PutAdapter(Integer.MAX_VALUE);

    public void encode(Mutation mutation, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        MutateRowRequest request;
        if (mutation instanceof Put) {
            request = PUT_ADAPTER.adapt((Put)mutation).build();
        } else if (mutation instanceof Delete) {
            request = Adapters.DELETE_ADAPTER.adapt((Delete)mutation).build();
        } else {
            throw new IllegalArgumentException("Only Put and Delete are supported");
        }
        request.writeDelimitedTo(outStream);
    }

    public Mutation decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        MutateRowRequest request = MutateRowRequest.parseDelimitedFrom(inStream);
        if (request.getMutationsCount() == 0) {
            throw new IllegalArgumentException("Invalid MutateRowRequest");
        }
        if (request.getMutations(0).getMutationCase() == Mutation.MutationCase.SET_CELL) {
            return PUT_ADAPTER.adapt(request);
        }
        return Adapters.DELETE_ADAPTER.adapt(request);
    }
}

