/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.dataflow.coders;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.Adapters;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.client.Result;

public class HBaseResultArrayCoder
extends AtomicCoder<Result[]> {
    private static final HBaseResultArrayCoder INSTANCE = new HBaseResultArrayCoder();
    private static final long serialVersionUID = -4975428837770254686L;

    public static HBaseResultArrayCoder getInstance() {
        return INSTANCE;
    }

    public Result[] decode(InputStream inputStream, Coder.Context context) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(inputStream);
        int resultCount = ois.readInt();
        Result[] results = new Result[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            results[i] = Adapters.ROW_ADAPTER.adaptResponse(Row.parseDelimitedFrom(inputStream));
        }
        return results;
    }

    public void encode(Result[] results, OutputStream outputStream, Coder.Context context) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeInt(results.length);
        oos.flush();
        for (Result result : results) {
            Adapters.ROW_ADAPTER.adaptToRow(result).writeDelimitedTo(outputStream);
        }
    }
}

