/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableSession;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.AsyncExecutor;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BulkRead;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.Adapters;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.HBaseRequestAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.coprocessor.Batch;

public class BatchExecutor {
    protected static final Logger LOG = new Logger(BatchExecutor.class);
    public static final byte[] NO_REGION = new byte[0];
    private static final Function<List<com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row>, com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row> ROWS_TO_ROW_CONVERTER = new Function<List<com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row>, com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row>(){

        @Override
        public com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row apply(List<com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row> rows) {
            if (rows.isEmpty()) {
                return null;
            }
            return rows.get(0);
        }
    };
    protected final BigtableSession session;
    protected final AsyncExecutor asyncExecutor;
    protected final BigtableOptions options;
    protected final HBaseRequestAdapter requestAdapter;

    public BatchExecutor(BigtableSession session, HBaseRequestAdapter requestAdapter) {
        this.session = session;
        this.asyncExecutor = session.createAsyncExecutor();
        this.options = session.getOptions();
        this.requestAdapter = requestAdapter;
    }

    private <R extends Row, T> ListenableFuture<Result> issueAsyncRowRequest(BulkOperation bulkOperation, Row row, Batch.Callback<T> callback, Object[] results, int index) {
        LOG.trace("issueRowRequest(BulkOperation, Row, Batch.Callback, Object[], index", new Object[0]);
        SettableFuture<Result> resultFuture = SettableFuture.create();
        RpcResultFutureCallback<T> futureCallback = new RpcResultFutureCallback<T>(row, callback, index, results, resultFuture);
        results[index] = null;
        Futures.addCallback(this.issueAsyncRequest(bulkOperation, row), futureCallback);
        return resultFuture;
    }

    private ListenableFuture<? extends GeneratedMessage> issueAsyncRequest(BulkOperation bulkOperation, Row row) {
        try {
            if (row instanceof Get) {
                return bulkOperation.readRowsAsync(this.requestAdapter.adapt((Get)row));
            }
            if (row instanceof Put) {
                return bulkOperation.mutateRowAsync(this.requestAdapter.adapt((Put)row));
            }
            if (row instanceof Delete) {
                return bulkOperation.mutateRowAsync(this.requestAdapter.adapt((Delete)row));
            }
            if (row instanceof Append) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.requestAdapter.adapt((Append)row));
            }
            if (row instanceof Increment) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.requestAdapter.adapt((Increment)row));
            }
            if (row instanceof RowMutations) {
                return bulkOperation.mutateRowAsync(this.requestAdapter.adapt((RowMutations)row));
            }
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture(new IOException("Could not process the batch", e));
        }
        LOG.error("Encountered unknown action type %s", row.getClass());
        return Futures.immediateFailedFuture(new IllegalArgumentException("Encountered unknown action type: " + row.getClass()));
    }

    public void batch(List<? extends Row> actions, @Nullable Object[] results) throws IOException, InterruptedException {
        if (results == null) {
            results = new Object[actions.size()];
        }
        Preconditions.checkArgument(results.length == actions.size(), "Result array must have same dimensions as actions list.");
        List<ListenableFuture<?>> resultFutures = this.issueAsyncRowRequests(actions, results, null);
        try {
            Futures.successfulAsList(resultFutures).get();
            ArrayList<Throwable> problems = new ArrayList<Throwable>();
            ArrayList<Row> problemActions = new ArrayList<Row>();
            ArrayList<String> hosts = new ArrayList<String>();
            for (int i = 0; i < resultFutures.size(); ++i) {
                try {
                    resultFutures.get(i).get();
                    continue;
                }
                catch (ExecutionException e) {
                    problemActions.add(actions.get(i));
                    problems.add(e.getCause());
                    hosts.add(this.options.getDataHost().toString());
                }
            }
            if (problems.size() > 0) {
                throw new RetriesExhaustedWithDetailsException(problems, problemActions, hosts);
            }
        }
        catch (ExecutionException e) {
            LOG.error("Encountered exception in batch(List<>, Object[]).", e, new Object[0]);
            throw new IOException("Batch error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> List<ListenableFuture<?>> issueAsyncRowRequests(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) {
        BulkOperation bulkOperation = new BulkOperation(this.session, this.asyncExecutor, this.requestAdapter.getBigtableTableName());
        try {
            ArrayList resultFutures = new ArrayList(actions.size());
            for (int i = 0; i < actions.size(); ++i) {
                resultFutures.add(this.issueAsyncRowRequest(bulkOperation, actions.get(i), callback, results, i));
            }
            ArrayList arrayList = resultFutures;
            return arrayList;
        }
        finally {
            bulkOperation.flush();
        }
    }

    public Result[] batch(List<? extends Row> actions) throws IOException {
        try {
            Object[] results = new Result[actions.size()];
            this.batch(actions, results);
            return results;
        }
        catch (InterruptedException e) {
            LOG.error("Encountered exception in batch(List<>).", e, new Object[0]);
            throw new IOException("Batch error", e);
        }
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        Preconditions.checkArgument(results.length == actions.size(), "Result array must be the same length as actions.");
        try {
            Futures.successfulAsList(this.issueAsyncRowRequests(actions, results, callback)).get();
        }
        catch (ExecutionException e) {
            LOG.error("Encountered exception in batchCallback(List<>, Object[], Batch.Callback). ", e, new Object[0]);
            throw new IOException("batchCallback error", e);
        }
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        Result[] getResults = this.batch(gets);
        Boolean[] exists = new Boolean[getResults.length];
        for (int index = 0; index < getResults.length; ++index) {
            exists[index] = !getResults[index].isEmpty();
        }
        return exists;
    }

    protected static class BulkOperation {
        private final AsyncExecutor asyncExecutor;
        private final BigtableOptions options;
        private BulkMutation bulkMutation;
        private BulkRead bulkRead;

        public BulkOperation(BigtableSession session, AsyncExecutor asyncExecutor, BigtableTableName tableName) {
            this.asyncExecutor = asyncExecutor;
            this.options = session.getOptions();
            this.bulkRead = session.createBulkRead(tableName);
            this.bulkMutation = session.createBulkMutation(tableName, asyncExecutor);
        }

        public ListenableFuture<? extends GeneratedMessage> mutateRowAsync(MutateRowRequest request) throws InterruptedException {
            if (!this.options.getBulkOptions().useBulkApi()) {
                return this.asyncExecutor.mutateRowAsync(request);
            }
            return this.bulkMutation.add(request);
        }

        public ListenableFuture<? extends GeneratedMessage> readRowsAsync(ReadRowsRequest request) throws InterruptedException {
            if (!this.options.getBulkOptions().useBulkApi()) {
                return Futures.transform(this.asyncExecutor.readRowsAsync(request), ROWS_TO_ROW_CONVERTER);
            }
            return Futures.transform(this.bulkRead.add(request), ROWS_TO_ROW_CONVERTER);
        }

        public void flush() {
            this.bulkMutation.flush();
            this.bulkRead.flush();
        }
    }

    static class RpcResultFutureCallback<T>
    implements FutureCallback<GeneratedMessage> {
        private final Row row;
        private final Batch.Callback<T> callback;
        private final int index;
        private final Object[] resultsArray;
        private final SettableFuture<Result> resultFuture;

        public RpcResultFutureCallback(Row row, Batch.Callback<T> callback, int index, Object[] resultsArray, SettableFuture<Result> resultFuture) {
            this.row = row;
            this.callback = callback;
            this.index = index;
            this.resultsArray = resultsArray;
            this.resultFuture = resultFuture;
        }

        @Override
        public final void onSuccess(GeneratedMessage message) {
            try {
                Result result = Result.EMPTY_RESULT;
                if (message instanceof com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row) {
                    result = Adapters.ROW_ADAPTER.adaptResponse((com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row)message);
                } else if (message instanceof ReadModifyWriteRowResponse) {
                    result = Adapters.ROW_ADAPTER.adaptResponse(((ReadModifyWriteRowResponse)message).getRow());
                }
                this.resultsArray[this.index] = result;
                this.resultFuture.set(result);
                if (this.callback != null) {
                    this.callback.update(NO_REGION, this.row.getRow(), (Object)result);
                }
            }
            catch (Throwable throwable) {
                this.resultFuture.setException(throwable);
            }
        }

        @Override
        public final void onFailure(Throwable throwable) {
            this.resultsArray[this.index] = null;
            this.resultFuture.setException(throwable);
            if (this.callback != null) {
                this.callback.update(NO_REGION, this.row.getRow(), null);
            }
        }
    }
}

