/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.BulkOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableSession;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.AsyncExecutor;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.HBaseRequestAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.util.Bytes;

public class BigtableBufferedMutator
implements BufferedMutator {
    protected static final Logger LOG = new Logger(BigtableBufferedMutator.class);
    protected static final long MUTATION_TO_BE_SENT_WAIT_MS = 1000L;
    private static final Runnable SHUTDOWN_MARKER = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final Configuration configuration;
    private final ReentrantReadWriteLock isClosedLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock closedReadLock = this.isClosedLock.readLock();
    private final ReentrantReadWriteLock.WriteLock closedWriteLock = this.isClosedLock.writeLock();
    private boolean closed = false;
    private final HBaseRequestAdapter adapter;
    private final BufferedMutator.ExceptionListener exceptionListener;
    private final AtomicBoolean hasExceptions = new AtomicBoolean(false);
    private final List<MutationException> globalExceptions = new ArrayList<MutationException>();
    private final String host;
    private final AsyncExecutor asyncExecutor;
    private final ExecutorService executorService;
    private final BulkOptions bulkOptions;
    private final LinkedBlockingQueue<Runnable> asyncOperationsQueue = new LinkedBlockingQueue();
    private final AtomicInteger activeMutationWorkers = new AtomicInteger();
    private BulkMutation bulkMutation = null;
    private final Runnable mutationWorker = new Runnable(){

        @Override
        public void run() {
            BigtableBufferedMutator.this.activeMutationWorkers.incrementAndGet();
            try {
                while (!BigtableBufferedMutator.this.executorService.isShutdown()) {
                    try {
                        Runnable operation = (Runnable)BigtableBufferedMutator.this.asyncOperationsQueue.poll(1000L, TimeUnit.MILLISECONDS);
                        if (operation == null) break;
                        if (operation == SHUTDOWN_MARKER) {
                            break;
                        }
                        operation.run();
                    }
                    catch (InterruptedException e) {
                        LOG.info("Interrupted. Shutting down the mutation worker.", new Object[0]);
                        break;
                    }
                    catch (Exception e) {
                        LOG.error("Exception in buffered mutator.", e, new Object[0]);
                    }
                }
            }
            finally {
                BigtableBufferedMutator.this.activeMutationWorkers.decrementAndGet();
            }
        }
    };

    public BigtableBufferedMutator(HBaseRequestAdapter adapter, Configuration configuration, BigtableSession session, BufferedMutator.ExceptionListener listener, ExecutorService asyncRpcExecutorService) {
        this.adapter = adapter;
        this.configuration = configuration;
        this.exceptionListener = listener;
        BigtableOptions options = session.getOptions();
        this.host = options.getDataHost().toString();
        this.asyncExecutor = session.createAsyncExecutor();
        this.bulkOptions = options.getBulkOptions();
        this.executorService = asyncRpcExecutorService;
        if (this.bulkOptions.useBulkApi()) {
            BigtableTableName tableName = this.adapter.getBigtableTableName();
            this.bulkMutation = session.createBulkMutation(tableName, this.asyncExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAsyncMutators() {
        if (this.executorService != null && this.activeMutationWorkers.get() < this.bulkOptions.getAsyncMutatorCount()) {
            AtomicInteger atomicInteger = this.activeMutationWorkers;
            synchronized (atomicInteger) {
                for (int i = this.activeMutationWorkers.get(); i < this.bulkOptions.getAsyncMutatorCount(); ++i) {
                    this.executorService.submit(this.mutationWorker);
                }
            }
        }
    }

    public void close() throws IOException {
        this.closedWriteLock.lock();
        try {
            this.flush();
            int activeWorkerCount = this.activeMutationWorkers.get();
            for (int i = 0; i < activeWorkerCount; ++i) {
                this.asyncOperationsQueue.add(SHUTDOWN_MARKER);
            }
            this.asyncExecutor.flush();
            this.closed = true;
        }
        finally {
            this.closedWriteLock.unlock();
        }
    }

    public void flush() throws IOException {
        if (!this.asyncOperationsQueue.isEmpty()) {
            this.initializeAsyncMutators();
        }
        if (this.bulkMutation != null) {
            this.bulkMutation.flush();
        }
        this.asyncExecutor.flush();
        this.handleExceptions();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TableName getName() {
        return this.adapter.getTableName();
    }

    public long getWriteBufferSize() {
        return this.asyncExecutor.getMaxHeapSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(List<? extends Mutation> mutations) throws IOException {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            this.handleExceptions();
            for (Mutation mutation : mutations) {
                this.offer(mutation);
            }
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    public void mutate(Mutation mutation) throws IOException {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            this.handleExceptions();
            this.offer(mutation);
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    private void offer(Mutation mutation) throws IOException {
        try {
            MutationOperation operation = null;
            if (this.bulkOptions.useBulkApi() && (mutation instanceof Put || mutation instanceof Delete)) {
                this.addExceptionCallback(this.bulkMutation.add(this.adapt(mutation)), mutation);
            } else {
                long operationId = this.asyncExecutor.getRpcThrottler().registerOperationWithHeapSize(mutation.heapSize());
                operation = new MutationOperation(mutation, operationId);
                if (this.executorService != null && this.bulkOptions.getAsyncMutatorCount() > 0) {
                    this.initializeAsyncMutators();
                    this.asyncOperationsQueue.add(operation);
                } else {
                    operation.run();
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted in buffered mutator while mutating row : '" + Bytes.toString((byte[])mutation.getRow()), e);
        }
    }

    private void issueRequest(Mutation mutation, long operationId) {
        this.addExceptionCallback(this.issueRequestDetails(mutation, operationId), mutation);
    }

    protected void addExceptionCallback(ListenableFuture<? extends GeneratedMessage> future, Mutation mutation) {
        Futures.addCallback(future, new ExceptionCallback((Row)mutation));
    }

    protected MutateRowRequest adapt(Mutation mutation) {
        if (mutation instanceof Put) {
            return this.adapter.adapt((Put)mutation);
        }
        if (mutation instanceof Delete) {
            return this.adapter.adapt((Delete)mutation);
        }
        throw new IllegalArgumentException("Encountered unknown mutation type: " + mutation.getClass());
    }

    private ListenableFuture<? extends GeneratedMessage> issueRequestDetails(Mutation mutation, long operationId) {
        try {
            if (mutation == null) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("Cannot perform a mutation on a null object."));
            }
            if (mutation instanceof Put) {
                return this.asyncExecutor.mutateRowAsync(this.adapter.adapt((Put)mutation), operationId);
            }
            if (mutation instanceof Delete) {
                return this.asyncExecutor.mutateRowAsync(this.adapter.adapt((Delete)mutation), operationId);
            }
            if (mutation instanceof Increment) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.adapter.adapt((Increment)mutation), operationId);
            }
            if (mutation instanceof Append) {
                return this.asyncExecutor.readModifyWriteRowAsync(this.adapter.adapt((Append)mutation), operationId);
            }
            return Futures.immediateFailedFuture(new IllegalArgumentException("Encountered unknown mutation type: " + mutation.getClass()));
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGlobalException(Row mutation, Throwable t) {
        List<MutationException> list = this.globalExceptions;
        synchronized (list) {
            this.globalExceptions.add(new MutationException(mutation, t));
            this.hasExceptions.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExceptions() throws RetriesExhaustedWithDetailsException {
        if (this.hasExceptions.get()) {
            ArrayList<MutationException> mutationExceptions = null;
            List<MutationException> list = this.globalExceptions;
            synchronized (list) {
                this.hasExceptions.set(false);
                if (this.globalExceptions.isEmpty()) {
                    return;
                }
                mutationExceptions = new ArrayList<MutationException>(this.globalExceptions);
                this.globalExceptions.clear();
            }
            ArrayList<Throwable> problems = new ArrayList<Throwable>(mutationExceptions.size());
            ArrayList<String> hostnames = new ArrayList<String>(mutationExceptions.size());
            ArrayList<Row> failedMutations = new ArrayList<Row>(mutationExceptions.size());
            for (MutationException mutationException : mutationExceptions) {
                problems.add(mutationException.throwable);
                failedMutations.add(mutationException.mutation);
                hostnames.add(this.host);
            }
            RetriesExhaustedWithDetailsException exception = new RetriesExhaustedWithDetailsException(problems, failedMutations, hostnames);
            this.exceptionListener.onException(exception, (BufferedMutator)this);
        }
    }

    public boolean hasInflightRequests() {
        return this.asyncExecutor.hasInflightRequests() || this.bulkMutation != null && !this.bulkMutation.isFlushed();
    }

    private class ExceptionCallback
    implements FutureCallback<GeneratedMessage> {
        private final Row mutation;

        public ExceptionCallback(Row mutation) {
            this.mutation = mutation;
        }

        @Override
        public void onFailure(Throwable t) {
            BigtableBufferedMutator.this.addGlobalException(this.mutation, t);
        }

        @Override
        public void onSuccess(GeneratedMessage ignored) {
        }
    }

    private class MutationOperation
    implements Runnable {
        final Mutation mutation;
        final long operationId;

        public MutationOperation(Mutation mutation, long operationId) {
            this.mutation = mutation;
            this.operationId = operationId;
        }

        @Override
        public void run() {
            BigtableBufferedMutator.this.issueRequest(this.mutation, this.operationId);
        }
    }

    private static class MutationException {
        private final Row mutation;
        private final Throwable throwable;

        MutationException(Row mutation, Throwable throwable) {
            this.mutation = mutation;
            this.throwable = throwable;
        }
    }
}

