/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.client.repackaged.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;

public class BigtableConfiguration {
    private static final String[] CONNECTION_CLASS_NAMES = new String[]{"com.google.cloud.bigtable.hbase1_0.BigtableConnection", "com.google.bigtable.repackaged.com.google.cloud.hbase1_1.BigtableConnection", "com.google.bigtable.repackaged.com.google.cloud.hbase1_2.BigtableConnection"};
    private static final Class<? extends Connection> CONNECTION_CLASS = BigtableConfiguration.getConnectionClass();

    private static Class<? extends Connection> getConnectionClass() {
        for (String className : CONNECTION_CLASS_NAMES) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static Configuration configure(String projectId, String instanceId) {
        Configuration config = new Configuration(false);
        config.set("google.bigtable.project.id", projectId);
        config.set("google.bigtable.instance.id", instanceId);
        return config;
    }

    public static Connection connect(String projectId, String instanceId) {
        return BigtableConfiguration.connect(BigtableConfiguration.configure(projectId, instanceId));
    }

    public static Connection connect(Configuration conf) {
        Preconditions.checkState(CONNECTION_CLASS != null, "Could not find an appropriate BigtableConnection class");
        try {
            return CONNECTION_CLASS.getConstructor(Configuration.class).newInstance(conf);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not find an appropriate constructor for " + CONNECTION_CLASS.getCanonicalName(), e);
        }
    }
}

