/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class BigtableConstants {
    private static final Logger LOG = new Logger(BigtableConstants.class);
    public static final byte BIGTABLE_COLUMN_SEPARATOR_BYTE = 58;
    public static final int BIGTABLE_COLUMN_SEPARATOR_LENGTH = 1;
    public static final ByteString BIGTABLE_COLUMN_SEPARATOR_BYTE_STRING = ByteString.copyFrom(new byte[]{58});
    public static final TimeUnit HBASE_TIMEUNIT = TimeUnit.MILLISECONDS;
    public static final TimeUnit BIGTABLE_TIMEUNIT = TimeUnit.MICROSECONDS;
    public static final String USER_AGENT = BigtableConstants.getUserAgent() + "," + BigtableConstants.getJavaVersion();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getUserAgent() {
        String defaultUserAgent = "bigtable-hbase/dev-" + System.currentTimeMillis();
        try (InputStream stream = BigtableConstants.class.getResourceAsStream("bigtable-hbase.properties");){
            if (stream == null) {
                LOG.error("Could not load properties file bigtable-hbase.properties", new Object[0]);
                String string = defaultUserAgent;
                return string;
            }
            Properties properties = new Properties();
            properties.load(stream);
            String value = properties.getProperty("bigtable.hbase.user_agent");
            if (value == null) {
                LOG.error("bigtable.hbase.user_agent not found in bigtable-hbase.properties.", new Object[0]);
                return defaultUserAgent;
            }
            if (value.startsWith("$")) {
                LOG.info("bigtable.hbase.user_agent property is not replaced.", new Object[0]);
                return defaultUserAgent;
            }
            String string = value;
            return string;
        }
        catch (IOException e) {
            LOG.error(String.format("Error while trying to get user agent name from bigtable-hbase.properties", new Object[0]), e, new Object[0]);
        }
        return defaultUserAgent;
    }

    private static String getJavaVersion() {
        return System.getProperty("java.specification.version");
    }
}

