/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.client.util.Strings;
import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.BulkOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.CallOptionsConfig;
import com.google.bigtable.repackaged.com.google.cloud.config.CredentialOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;

public class BigtableOptionsFactory {
    protected static final Logger LOG = new Logger(BigtableOptionsFactory.class);
    public static final String BIGTABLE_PORT_KEY = "google.bigtable.endpoint.port";
    public static final String BIGTABLE_INSTANCE_ADMIN_HOST_KEY = "google.bigtable.instance.admin.endpoint.host";
    public static final String BIGTABLE_TABLE_ADMIN_HOST_KEY = "google.bigtable.admin.endpoint.host";
    public static final String BIGTABLE_HOST_KEY = "google.bigtable.endpoint.host";
    public static final String PROJECT_ID_KEY = "google.bigtable.project.id";
    public static final String INSTANCE_ID_KEY = "google.bigtable.instance.id";
    public static final String BIGTABE_USE_SERVICE_ACCOUNTS_KEY = "google.bigtable.auth.service.account.enable";
    public static final boolean BIGTABLE_USE_SERVICE_ACCOUNTS_DEFAULT = true;
    public static final String BIGTABLE_NULL_CREDENTIAL_ENABLE_KEY = "google.bigtable.auth.null.credential.enable";
    public static final boolean BIGTABLE_NULL_CREDENTIAL_ENABLE_DEFAULT = false;
    public static final String BIGTABLE_SERVICE_ACCOUNT_EMAIL_KEY = "google.bigtable.auth.service.account.email";
    public static final String BIGTABLE_SERVICE_ACCOUNT_P12_KEYFILE_LOCATION_KEY = "google.bigtable.auth.service.account.keyfile";
    public static final String BIGTABLE_SERVICE_ACCOUNT_JSON_KEYFILE_LOCATION_KEY = "google.bigtable.auth.json.keyfile";
    public static final String ENABLE_GRPC_RETRIES_KEY = "google.bigtable.grpc.retry.enable";
    public static final String ALLOW_NO_TIMESTAMP_RETRIES_KEY = "google.bigtable.alllow.no.timestamp.retries";
    public static final String ADDITIONAL_RETRY_CODES = "google.bigtable.grpc.retry.codes";
    public static final String ENABLE_GRPC_RETRY_DEADLINEEXCEEDED_KEY = "google.bigtable.grpc.retry.deadlineexceeded.enable";
    public static final String MAX_ELAPSED_BACKOFF_MILLIS_KEY = "google.bigtable.grpc.retry.max.elapsed.backoff.ms";
    public static final String READ_PARTIAL_ROW_TIMEOUT_MS = "google.bigtable.grpc.read.partial.row.timeout.ms";
    public static final String MAX_SCAN_TIMEOUT_RETRIES = "google.bigtable.grpc.retry.max.scan.timeout.retries";
    public static final String READ_BUFFER_SIZE = "google.bigtable.grpc.read.streaming.buffer.size";
    public static final String READ_BATCH_SIZE = "google.bigtable.grpc.read.streaming.batch.size";
    public static final String BIGTABLE_DATA_CHANNEL_COUNT_KEY = "google.bigtable.grpc.channel.count";
    public static final String BIGTABLE_USE_BULK_API = "google.bigtable.use.bulk.api";
    public static final String BIGTABLE_BULK_MAX_REQUEST_SIZE_BYTES = "google.bigtable.bulk.max.request.size.bytes";
    public static final String BIGTABLE_BULK_MAX_ROW_KEY_COUNT = "google.bigtable.bulk.max.row.key.count";
    public static final String MAX_INFLIGHT_RPCS_KEY = "google.bigtable.buffered.mutator.max.inflight.rpcs";
    public static final String BIGTABLE_BUFFERED_MUTATOR_MAX_MEMORY_KEY = "google.bigtable.buffered.mutator.max.memory";
    public static final String BIGTABLE_USE_PLAINTEXT_NEGOTIATION = "google.bigtable.use.plaintext.negotiation";
    public static final String BIGTABLE_ASYNC_MUTATOR_COUNT_KEY = "google.bigtable.buffered.mutator.async.worker.count";
    public static final String BIGTABLE_USE_TIMEOUTS_KEY = "google.bigtable.rpc.use.timeouts";
    public static final String BIGTABLE_RPC_TIMEOUT_MS_KEY = "google.bigtable.rpc.timeout.ms";

    public static BigtableOptions fromConfiguration(Configuration configuration) throws IOException {
        BigtableOptions.Builder bigtableOptionsBuilder = new BigtableOptions.Builder();
        bigtableOptionsBuilder.setProjectId(BigtableOptionsFactory.getValue(configuration, PROJECT_ID_KEY, "Project ID"));
        bigtableOptionsBuilder.setInstanceId(BigtableOptionsFactory.getValue(configuration, INSTANCE_ID_KEY, "Instance ID"));
        bigtableOptionsBuilder.setDataHost(BigtableOptionsFactory.getHost(configuration, BIGTABLE_HOST_KEY, "bigtable.googleapis.com", "API Data"));
        bigtableOptionsBuilder.setTableAdminHost(BigtableOptionsFactory.getHost(configuration, BIGTABLE_TABLE_ADMIN_HOST_KEY, "bigtableadmin.googleapis.com", "Table Admin"));
        bigtableOptionsBuilder.setInstanceAdminHost(BigtableOptionsFactory.getHost(configuration, BIGTABLE_INSTANCE_ADMIN_HOST_KEY, "bigtableadmin.googleapis.com", "Cluster Admin"));
        int port = configuration.getInt(BIGTABLE_PORT_KEY, 443);
        bigtableOptionsBuilder.setPort(port);
        bigtableOptionsBuilder.setUsePlaintextNegotiation(configuration.getBoolean(BIGTABLE_USE_PLAINTEXT_NEGOTIATION, false));
        BigtableOptionsFactory.setBulkOptions(configuration, bigtableOptionsBuilder);
        BigtableOptionsFactory.setChannelOptions(configuration, bigtableOptionsBuilder);
        BigtableOptionsFactory.setClientCallOptions(configuration, bigtableOptionsBuilder);
        return bigtableOptionsBuilder.build();
    }

    private static String getValue(Configuration configuration, String key, String type) {
        String value = configuration.get(key);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(value), String.format("%s must be supplied via %s", type, key));
        LOG.debug("%s %s", type, value);
        return value;
    }

    private static String getHost(Configuration configuration, String key, String defaultVal, String type) {
        String hostName = configuration.get(key, defaultVal);
        LOG.debug("%s endpoint host %s.", type, hostName);
        return hostName;
    }

    private static void setChannelOptions(Configuration configuration, BigtableOptions.Builder builder) throws IOException {
        BigtableOptionsFactory.setCredentialOptions(builder, configuration);
        builder.setRetryOptions(BigtableOptionsFactory.createRetryOptions(configuration));
        int channelCount = configuration.getInt(BIGTABLE_DATA_CHANNEL_COUNT_KEY, BigtableOptions.BIGTABLE_DATA_CHANNEL_COUNT_DEFAULT);
        builder.setDataChannelCount(channelCount);
        builder.setUserAgent(BigtableConstants.USER_AGENT);
    }

    private static void setBulkOptions(Configuration configuration, BigtableOptions.Builder bigtableOptionsBuilder) {
        BulkOptions.Builder bulkOptionsBuilder = new BulkOptions.Builder();
        int asyncMutatorCount = configuration.getInt(BIGTABLE_ASYNC_MUTATOR_COUNT_KEY, 2);
        bulkOptionsBuilder.setAsyncMutatorWorkerCount(asyncMutatorCount);
        bulkOptionsBuilder.setUseBulkApi(configuration.getBoolean(BIGTABLE_USE_BULK_API, true));
        bulkOptionsBuilder.setBulkMaxRowKeyCount(configuration.getInt(BIGTABLE_BULK_MAX_ROW_KEY_COUNT, 100));
        bulkOptionsBuilder.setBulkMaxRequestSize(configuration.getLong(BIGTABLE_BULK_MAX_REQUEST_SIZE_BYTES, 0x100000L));
        int defaultRpcCount = 50 * bigtableOptionsBuilder.getDataChannelCount();
        int maxInflightRpcs = configuration.getInt(MAX_INFLIGHT_RPCS_KEY, defaultRpcCount);
        bulkOptionsBuilder.setMaxInflightRpcs(maxInflightRpcs);
        long maxMemory = configuration.getLong(BIGTABLE_BUFFERED_MUTATOR_MAX_MEMORY_KEY, BulkOptions.BIGTABLE_MAX_MEMORY_DEFAULT);
        bulkOptionsBuilder.setMaxMemory(maxMemory);
        bigtableOptionsBuilder.setBulkOptions(bulkOptionsBuilder.build());
    }

    private static void setCredentialOptions(BigtableOptions.Builder builder, Configuration configuration) throws FileNotFoundException {
        if (configuration.getBoolean(BIGTABE_USE_SERVICE_ACCOUNTS_KEY, true)) {
            LOG.debug("Using service accounts", new Object[0]);
            if (configuration.get(BIGTABLE_SERVICE_ACCOUNT_JSON_KEYFILE_LOCATION_KEY) != null) {
                String keyfileLocation = configuration.get(BIGTABLE_SERVICE_ACCOUNT_JSON_KEYFILE_LOCATION_KEY);
                LOG.debug("Using json keyfile: %s", keyfileLocation);
                builder.setCredentialOptions(CredentialOptions.jsonCredentials(new FileInputStream(keyfileLocation)));
            } else if (configuration.get(BIGTABLE_SERVICE_ACCOUNT_EMAIL_KEY) != null) {
                String serviceAccount = configuration.get(BIGTABLE_SERVICE_ACCOUNT_EMAIL_KEY);
                LOG.debug("Service account %s specified.", serviceAccount);
                String keyfileLocation = configuration.get(BIGTABLE_SERVICE_ACCOUNT_P12_KEYFILE_LOCATION_KEY);
                Preconditions.checkState(!Strings.isNullOrEmpty(keyfileLocation), "Key file location must be specified when setting service account email");
                LOG.debug("Using p12 keyfile: %s", keyfileLocation);
                builder.setCredentialOptions(CredentialOptions.p12Credential(serviceAccount, keyfileLocation));
            } else {
                LOG.debug("Using default credentials.", new Object[0]);
                builder.setCredentialOptions(CredentialOptions.defaultCredentials());
            }
        } else if (configuration.getBoolean(BIGTABLE_NULL_CREDENTIAL_ENABLE_KEY, false)) {
            builder.setCredentialOptions(CredentialOptions.nullCredential());
            LOG.info("Enabling the use of null credentials. This should not be used in production.", new Object[0]);
        } else {
            throw new IllegalStateException("Either service account or null credentials must be enabled");
        }
    }

    private static void setClientCallOptions(Configuration configuration, BigtableOptions.Builder bigtableOptionsBuilder) {
        CallOptionsConfig.Builder clientCallOptionsBuilder = new CallOptionsConfig.Builder();
        clientCallOptionsBuilder.setUseTimeout(configuration.getBoolean(BIGTABLE_USE_TIMEOUTS_KEY, false));
        clientCallOptionsBuilder.setTimeoutMs(configuration.getInt(BIGTABLE_RPC_TIMEOUT_MS_KEY, 60000));
        bigtableOptionsBuilder.setCallOptionsConfig(clientCallOptionsBuilder.build());
    }

    private static RetryOptions createRetryOptions(Configuration configuration) {
        String[] codes;
        RetryOptions.Builder retryOptionsBuilder = new RetryOptions.Builder();
        boolean enableRetries = configuration.getBoolean(ENABLE_GRPC_RETRIES_KEY, true);
        LOG.debug("gRPC retries enabled: %s", enableRetries);
        retryOptionsBuilder.setEnableRetries(enableRetries);
        boolean allowRetriesWithoutTimestamp = configuration.getBoolean(ALLOW_NO_TIMESTAMP_RETRIES_KEY, false);
        LOG.debug("allow retries without timestamp: %s", enableRetries);
        retryOptionsBuilder.setAllowRetriesWithoutTimestamp(allowRetriesWithoutTimestamp);
        String retryCodes = configuration.get(ADDITIONAL_RETRY_CODES, "");
        for (String stringCode : codes = retryCodes.split(",")) {
            String trimmed = stringCode.trim();
            if (trimmed.isEmpty()) continue;
            Status.Code code = Status.Code.valueOf(trimmed);
            Preconditions.checkArgument(code != null, "Code " + stringCode + " not found.");
            LOG.debug("gRPC retry on: %s", stringCode);
            retryOptionsBuilder.addStatusToRetryOn(code);
        }
        boolean retryOnDeadlineExceeded = configuration.getBoolean(ENABLE_GRPC_RETRY_DEADLINEEXCEEDED_KEY, true);
        LOG.debug("gRPC retry on deadline exceeded enabled: %s", retryOnDeadlineExceeded);
        retryOptionsBuilder.setRetryOnDeadlineExceeded(retryOnDeadlineExceeded);
        int maxElapsedBackoffMillis = configuration.getInt(MAX_ELAPSED_BACKOFF_MILLIS_KEY, RetryOptions.DEFAULT_MAX_ELAPSED_BACKOFF_MILLIS);
        LOG.debug("gRPC retry maxElapsedBackoffMillis: %d", maxElapsedBackoffMillis);
        retryOptionsBuilder.setMaxElapsedBackoffMillis(maxElapsedBackoffMillis);
        int readPartialRowTimeoutMillis = configuration.getInt(READ_PARTIAL_ROW_TIMEOUT_MS, RetryOptions.DEFAULT_READ_PARTIAL_ROW_TIMEOUT_MS);
        LOG.debug("gRPC read partial row timeout (millis): %d", readPartialRowTimeoutMillis);
        retryOptionsBuilder.setReadPartialRowTimeoutMillis(readPartialRowTimeoutMillis);
        int streamingBufferSize = configuration.getInt(READ_BUFFER_SIZE, RetryOptions.DEFAULT_STREAMING_BUFFER_SIZE);
        LOG.debug("gRPC read buffer size (count): %d", streamingBufferSize);
        retryOptionsBuilder.setStreamingBufferSize(streamingBufferSize);
        int streamingBatchSize = configuration.getInt(READ_BATCH_SIZE, RetryOptions.DEFAULT_STREAMING_BATCH_SIZE);
        LOG.debug("gRPC read batch size (count): %d", streamingBatchSize);
        retryOptionsBuilder.setStreamingBatchSize(streamingBatchSize);
        int maxScanTimeoutRetries = configuration.getInt(MAX_SCAN_TIMEOUT_RETRIES, 3);
        LOG.debug("gRPC max scan timeout retries (count): %d", maxScanTimeoutRetries);
        retryOptionsBuilder.setMaxScanTimeoutRetries(maxScanTimeoutRetries);
        return retryOptionsBuilder.build();
    }
}

