/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.client.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableSession;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.Adapters;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.HBaseRequestAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.ReadHooks;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Mutation;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.com.google.protobuf.Descriptors;
import com.google.bigtable.repackaged.com.google.protobuf.Message;
import com.google.bigtable.repackaged.com.google.protobuf.Service;
import com.google.bigtable.repackaged.com.google.protobuf.ServiceException;
import com.google.cloud.bigtable.hbase.BatchExecutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;

public class BigtableTable
implements Table {
    protected static final Logger LOG = new Logger(BigtableTable.class);
    private static final ReadHooks UNSUPPORTED_READ_HOOKS = new ReadHooks(){

        @Override
        public void composePreSendHook(Function<ReadRowsRequest, ReadRowsRequest> newHook) {
            throw new IllegalStateException("We built a bad Filter for conditional mutation.");
        }

        @Override
        public ReadRowsRequest applyPreSendHook(ReadRowsRequest readRowsRequest) {
            throw new UnsupportedOperationException("We built a bad Filter for conditional mutation.");
        }
    };
    protected final TableName tableName;
    protected final BigtableOptions options;
    protected final HBaseRequestAdapter hbaseAdapter;
    protected final BigtableDataClient client;
    private BatchExecutor batchExecutor;
    protected final AbstractBigtableConnection bigtableConnection;

    public BigtableTable(AbstractBigtableConnection bigtableConnection, HBaseRequestAdapter hbaseAdapter) {
        this.bigtableConnection = bigtableConnection;
        BigtableSession session = bigtableConnection.getSession();
        this.options = session.getOptions();
        this.client = session.getDataClient();
        this.hbaseAdapter = hbaseAdapter;
        this.tableName = hbaseAdapter.getTableName();
    }

    public TableName getName() {
        return this.tableName;
    }

    public final Configuration getConfiguration() {
        return this.bigtableConnection.getConfiguration();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        try (Admin admin = this.bigtableConnection.getAdmin();){
            HTableDescriptor hTableDescriptor = admin.getTableDescriptor(this.tableName);
            return hTableDescriptor;
        }
    }

    public boolean exists(Get get) throws IOException {
        LOG.trace("exists(Get)", new Object[0]);
        Result result = this.get(get);
        return !result.isEmpty();
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        LOG.trace("existsAll(Get)", new Object[0]);
        Boolean[] existsObjects = this.getBatchExecutor().exists(gets);
        boolean[] exists = new boolean[existsObjects.length];
        for (int i = 0; i < existsObjects.length; ++i) {
            exists[i] = existsObjects[i];
        }
        return exists;
    }

    public void batch(List<? extends org.apache.hadoop.hbase.client.Row> actions, Object[] results) throws IOException, InterruptedException {
        LOG.trace("batch(List<>, Object[])", new Object[0]);
        this.getBatchExecutor().batch(actions, results);
    }

    @Deprecated
    public Object[] batch(List<? extends org.apache.hadoop.hbase.client.Row> actions) throws IOException, InterruptedException {
        LOG.trace("batch(List<>)", new Object[0]);
        return this.getBatchExecutor().batch(actions);
    }

    public <R> void batchCallback(List<? extends org.apache.hadoop.hbase.client.Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        LOG.trace("batchCallback(List<>, Object[], Batch.Callback)", new Object[0]);
        this.getBatchExecutor().batchCallback(actions, results, callback);
    }

    @Deprecated
    public <R> Object[] batchCallback(List<? extends org.apache.hadoop.hbase.client.Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        LOG.trace("batchCallback(List<>, Batch.Callback)", new Object[0]);
        Object[] results = new Object[actions.size()];
        this.getBatchExecutor().batchCallback(actions, results, callback);
        return results;
    }

    public Result[] get(List<Get> gets) throws IOException {
        LOG.trace("get(List<>)", new Object[0]);
        return this.getBatchExecutor().batch(gets);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result get(Get get) throws IOException {
        LOG.trace("get(Get)", new Object[0]);
        try (com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ResultScanner<Row> scanner = this.client.readRows(this.hbaseAdapter.adapt(get));){
            Result result = Adapters.ROW_ADAPTER.adaptResponse(scanner.next());
            return result;
        }
        catch (Throwable t) {
            throw this.logAndCreateIOException("get", get.getRow(), t);
        }
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        try {
            LOG.trace("getScanner(Scan)", new Object[0]);
            com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ResultScanner<Row> scanner = this.client.readRows(this.hbaseAdapter.adapt(scan));
            if (BigtableTable.hasWhileMatchFilter(scan.getFilter())) {
                return Adapters.BIGTABLE_WHILE_MATCH_RESULT_RESULT_SCAN_ADAPTER.adapt(scanner);
            }
            return Adapters.BIGTABLE_RESULT_SCAN_ADAPTER.adapt(scanner);
        }
        catch (Throwable throwable) {
            LOG.error("Encountered exception when executing getScanner.", throwable, new Object[0]);
            throw new IOException(BigtableTable.makeGenericExceptionMessage("getScanner", this.options.getProjectId(), this.tableName.getQualifierAsString()), throwable);
        }
    }

    @VisibleForTesting
    static boolean hasWhileMatchFilter(Filter filter) {
        if (filter instanceof WhileMatchFilter) {
            return true;
        }
        if (filter instanceof FilterList) {
            FilterList list = (FilterList)filter;
            for (Filter subFilter : list.getFilters()) {
                if (!BigtableTable.hasWhileMatchFilter(subFilter)) continue;
                return true;
            }
        }
        return false;
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        LOG.trace("getScanner(byte[])", new Object[0]);
        return this.getScanner(new Scan().addFamily(family));
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        LOG.trace("getScanner(byte[], byte[])", new Object[0]);
        return this.getScanner(new Scan().addColumn(family, qualifier));
    }

    public void put(Put put) throws IOException {
        LOG.trace("put(Put)", new Object[0]);
        MutateRowRequest request = this.hbaseAdapter.adapt(put);
        try {
            this.client.mutateRow(request);
        }
        catch (Throwable t) {
            throw this.logAndCreateIOException("put", put.getRow(), t);
        }
    }

    public void put(List<Put> puts) throws IOException {
        LOG.trace("put(List<Put>)", new Object[0]);
        this.getBatchExecutor().batch(puts);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.checkAndPut(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, put);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        CheckAndMutateRowRequest.Builder requestBuilder = this.makeConditionalMutationRequestBuilder(row, family, qualifier, compareOp, value, put.getRow(), this.hbaseAdapter.adapt(put).getMutationsList());
        try {
            CheckAndMutateRowResponse response = this.client.checkAndMutateRow(requestBuilder.build());
            return this.wasMutationApplied(requestBuilder, response);
        }
        catch (Throwable t) {
            throw this.logAndCreateIOException("checkAndPut", row, t);
        }
    }

    public void delete(Delete delete) throws IOException {
        LOG.trace("delete(Delete)", new Object[0]);
        MutateRowRequest request = this.hbaseAdapter.adapt(delete);
        try {
            this.client.mutateRow(request);
        }
        catch (Throwable t) {
            throw this.logAndCreateIOException("delete", delete.getRow(), t);
        }
    }

    public void delete(List<Delete> deletes) throws IOException {
        LOG.trace("delete(List<Delete>)", new Object[0]);
        this.getBatchExecutor().batch(deletes);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.checkAndDelete(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, delete);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        CheckAndMutateRowRequest.Builder requestBuilder = this.makeConditionalMutationRequestBuilder(row, family, qualifier, compareOp, value, delete.getRow(), this.hbaseAdapter.adapt(delete).getMutationsList());
        try {
            CheckAndMutateRowResponse response = this.client.checkAndMutateRow(requestBuilder.build());
            return this.wasMutationApplied(requestBuilder, response);
        }
        catch (Throwable t) {
            throw this.logAndCreateIOException("checkAndDelete", row, t);
        }
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm) throws IOException {
        ArrayList<Mutation> adaptedMutations = new ArrayList<Mutation>();
        for (org.apache.hadoop.hbase.client.Mutation mut : rm.getMutations()) {
            adaptedMutations.addAll(this.hbaseAdapter.adapt(mut).getMutationsList());
        }
        CheckAndMutateRowRequest.Builder requestBuilder = this.makeConditionalMutationRequestBuilder(row, family, qualifier, compareOp, value, rm.getRow(), adaptedMutations);
        try {
            CheckAndMutateRowResponse response = this.client.checkAndMutateRow(requestBuilder.build());
            return this.wasMutationApplied(requestBuilder, response);
        }
        catch (Throwable t) {
            throw this.logAndCreateIOException("checkAndMutate", row, t);
        }
    }

    public void mutateRow(RowMutations rm) throws IOException {
        LOG.trace("mutateRow(RowMutation)", new Object[0]);
        MutateRowRequest request = this.hbaseAdapter.adapt(rm);
        try {
            this.client.mutateRow(request);
        }
        catch (Throwable t) {
            throw this.logAndCreateIOException("mutateRow", rm.getRow(), t);
        }
    }

    public Result append(Append append) throws IOException {
        LOG.trace("append(Append)", new Object[0]);
        ReadModifyWriteRowRequest request = this.hbaseAdapter.adapt(append);
        try {
            ReadModifyWriteRowResponse response = this.client.readModifyWriteRow(request);
            if (append.isReturnResults()) {
                return Adapters.ROW_ADAPTER.adaptResponse(response.getRow());
            }
            return null;
        }
        catch (Throwable t) {
            throw this.logAndCreateIOException("append", append.getRow(), t);
        }
    }

    public Result increment(Increment increment) throws IOException {
        LOG.trace("increment(Increment)", new Object[0]);
        ReadModifyWriteRowRequest request = this.hbaseAdapter.adapt(increment);
        try {
            return Adapters.ROW_ADAPTER.adaptResponse(this.client.readModifyWriteRow(request).getRow());
        }
        catch (Throwable t) {
            throw this.logAndCreateIOException("increment", increment.getRow(), t);
        }
    }

    private IOException logAndCreateIOException(String type, byte[] row, Throwable t) {
        LOG.error("Encountered exception when executing " + type + ".", t, new Object[0]);
        return new IOException(BigtableTable.makeGenericExceptionMessage(type, this.options.getProjectId(), this.tableName.getQualifierAsString(), row), t);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        LOG.trace("incrementColumnValue(byte[], byte[], byte[], long)", new Object[0]);
        Increment incr = new Increment(row);
        incr.addColumn(family, qualifier, amount);
        Result result = this.increment(incr);
        Cell cell = result.getColumnLatestCell(family, qualifier);
        if (cell == null) {
            LOG.error("Failed to find a incremented value in result of increment", new Object[0]);
            throw new IOException(BigtableTable.makeGenericExceptionMessage("increment", this.options.getProjectId(), this.tableName.getQualifierAsString(), row));
        }
        return Bytes.toLong((byte[])CellUtil.cloneValue((Cell)cell));
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        LOG.trace("incrementColumnValue(byte[], byte[], byte[], long, Durability)", new Object[0]);
        return this.incrementColumnValue(row, family, qualifier, amount);
    }

    public void close() throws IOException {
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        LOG.error("Unsupported coprocessorService(byte[]) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        LOG.error("Unsupported coprocessorService(Class, byte[], byte[], Batch.Call) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        LOG.error("Unsupported coprocessorService(Class, byte[], byte[], Batch.Call, Batch.Callback) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long getWriteBufferSize() {
        LOG.error("Unsupported getWriteBufferSize() called", new Object[0]);
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        LOG.error("Unsupported getWriteBufferSize() called", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] bytes, byte[] bytes2, R r) throws ServiceException, Throwable {
        LOG.error("Unsupported batchCoprocessorService(MethodDescriptor, Message, byte[], byte[], R) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message message, byte[] bytes, byte[] bytes2, R r, Batch.Callback<R> rCallback) throws ServiceException, Throwable {
        LOG.error("Unsupported batchCoprocessorService(MethodDescriptor, Message, byte[], byte[], R, Batch.Callback<R>) called.", new Object[0]);
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper(BigtableTable.class).add("hashCode", "0x" + Integer.toHexString(this.hashCode())).add("project", this.options.getProjectId()).add("instance", this.options.getInstanceId()).add("table", this.tableName.getNameAsString()).add("host", this.options.getDataHost()).toString();
    }

    protected boolean wasMutationApplied(CheckAndMutateRowRequest.Builder requestBuilder, CheckAndMutateRowResponse response) {
        return requestBuilder.getTrueMutationsCount() > 0 && response.getPredicateMatched() || requestBuilder.getFalseMutationsCount() > 0 && !response.getPredicateMatched();
    }

    protected CheckAndMutateRowRequest.Builder makeConditionalMutationRequestBuilder(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, byte[] actionRow, List<Mutation> mutations) throws IOException {
        if (!Arrays.equals(actionRow, row)) {
            throw new DoNotRetryIOException("Action's getRow must match the passed row");
        }
        CheckAndMutateRowRequest.Builder requestBuilder = CheckAndMutateRowRequest.newBuilder();
        requestBuilder.setTableName(this.hbaseAdapter.getBigtableTableName().toString());
        requestBuilder.setRowKey(ByteString.copyFrom(row));
        Scan scan = new Scan().addColumn(family, qualifier);
        scan.setMaxVersions(1);
        if (value == null) {
            if (CompareFilter.CompareOp.EQUAL.equals((Object)compareOp)) {
                requestBuilder.addAllFalseMutations(mutations);
            } else if (CompareFilter.CompareOp.NOT_EQUAL.equals((Object)compareOp)) {
                requestBuilder.addAllTrueMutations(mutations);
            }
        } else {
            ValueFilter valueFilter = new ValueFilter(compareOp, (ByteArrayComparable)new BinaryComparator(value));
            scan.setFilter((Filter)valueFilter);
            requestBuilder.addAllTrueMutations(mutations);
        }
        requestBuilder.setPredicateFilter(Adapters.SCAN_ADAPTER.buildFilter(scan, UNSUPPORTED_READ_HOOKS));
        return requestBuilder;
    }

    static String makeGenericExceptionMessage(String operation, String projectId, String tableName) {
        return String.format("Failed to perform operation. Operation='%s', projectId='%s', tableName='%s'", operation, projectId, tableName);
    }

    static String makeGenericExceptionMessage(String operation, String projectId, String tableName, byte[] rowKey) {
        return String.format("Failed to perform operation. Operation='%s', projectId='%s', tableName='%s', rowKey='%s'", operation, projectId, tableName, Bytes.toStringBinary((byte[])rowKey));
    }

    protected synchronized BatchExecutor getBatchExecutor() {
        if (this.batchExecutor == null) {
            this.batchExecutor = new BatchExecutor(this.bigtableConnection.getSession(), this.hbaseAdapter);
        }
        return this.batchExecutor;
    }
}

