/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.CredentialFactory;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.cloud.bigtable.hbase.BigtableOptionsFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.util.GenericOptionsParser;

public class CheckConfig {
    public static void main(String[] args) throws IOException, GeneralSecurityException {
        BigtableOptions options;
        Logger logger = new Logger(CheckConfig.class);
        GenericOptionsParser optionsParser = new GenericOptionsParser(HBaseConfiguration.create(), args);
        Configuration fullConfiguration = optionsParser.getConfiguration();
        try {
            options = BigtableOptionsFactory.fromConfiguration(fullConfiguration);
        }
        catch (IOException | RuntimeException exc) {
            logger.warn("Encountered errors attempting to parse configuration.", exc, new Object[0]);
            return;
        }
        System.out.println(String.format("User Agent: %s", options.getUserAgent()));
        System.out.println(String.format("Project ID: %s", options.getProjectId()));
        System.out.println(String.format("Instance Id: %s", options.getInstanceId()));
        System.out.println(String.format("Instance admin host: %s", options.getInstanceAdminHost()));
        System.out.println(String.format("Table admin host: %s", options.getTableAdminHost()));
        System.out.println(String.format("Data host: %s", options.getDataHost()));
        Credentials credentials = CredentialFactory.getCredentials(options.getCredentialOptions());
        try {
            System.out.println("Attempting credential refresh...");
            credentials.refresh();
        }
        catch (IOException ioe) {
            logger.warn("Encountered errors attempting to refresh credentials.", ioe, new Object[0]);
            return;
        }
        String configuredConnectionClass = fullConfiguration.get("hbase.client.connection.impl");
        boolean isCorrectClassSpecified = false;
        if (!Strings.isNullOrEmpty(configuredConnectionClass)) {
            try {
                Class<?> connectionClass = Class.forName(configuredConnectionClass);
                isCorrectClassSpecified = AbstractBigtableConnection.class.isAssignableFrom(connectionClass);
            }
            catch (Exception connectionClass) {
                // empty catch block
            }
        }
        System.out.println(String.format("HBase Connection Class = %s %s", configuredConnectionClass, isCorrectClassSpecified ? "(OK)" : "(Configuration error)"));
        System.out.println("Opening table admin connection...");
        try (Connection conn = ConnectionFactory.createConnection((Configuration)fullConfiguration);){
            try (Admin admin = conn.getAdmin();){
                System.out.println(String.format("Tables in cluster %s:", options.getInstanceId()));
                TableName[] tableNames = admin.listTableNames();
                if (tableNames.length == 0) {
                    System.out.println("No tables found.");
                } else {
                    for (TableName table : tableNames) {
                        System.out.println(table.getNameAsString());
                    }
                }
            }
            System.out.println("Closing connection...");
        }
    }
}

