/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableInstanceName;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableTableAdminClient;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.admin.ColumnDescriptorAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.admin.TableAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.Table;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public abstract class AbstractBigtableAdmin
implements Admin {
    private static final Logger LOG = new Logger(AbstractBigtableAdmin.class);
    private final Set<TableName> disabledTables;
    private final Configuration configuration;
    private final BigtableOptions options;
    private final AbstractBigtableConnection connection;
    private final BigtableTableAdminClient bigtableTableAdminClient;
    private BigtableInstanceName bigtableInstanceName;
    private final ColumnDescriptorAdapter columnDescriptorAdapter = new ColumnDescriptorAdapter();
    private final TableAdapter tableAdapter;

    public AbstractBigtableAdmin(BigtableOptions options, Configuration configuration, AbstractBigtableConnection connection, BigtableTableAdminClient bigtableTableAdminClient, Set<TableName> disabledTables) {
        LOG.debug("Creating BigtableAdmin", new Object[0]);
        this.configuration = configuration;
        this.options = options;
        this.connection = connection;
        this.bigtableTableAdminClient = bigtableTableAdminClient;
        this.disabledTables = disabledTables;
        this.bigtableInstanceName = options.getInstanceName();
        this.tableAdapter = new TableAdapter(options, this.columnDescriptorAdapter);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean tableExists(TableName tableName) throws IOException {
        for (TableName existingTableName : this.listTableNames(tableName.getNameAsString())) {
            if (!existingTableName.equals((Object)tableName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean tableExists(String tableName) throws IOException {
        return this.tableExists(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.getTableDescriptors(this.listTableNames());
    }

    private HTableDescriptor[] getTableDescriptors(TableName[] tableNames) throws IOException {
        HTableDescriptor[] response = new HTableDescriptor[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            response[i] = this.getTableDescriptor(tableNames[i]);
        }
        return response;
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.getTableDescriptors(this.listTableNames(pattern));
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables(pattern);
    }

    @Deprecated
    public TableName[] listTableNames(String patternStr) throws IOException {
        return this.listTableNames(Pattern.compile(patternStr));
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        ArrayList<TableName> result = new ArrayList<TableName>();
        for (TableName tableName : this.listTableNames()) {
            if (!pattern.matcher(tableName.getNameAsString()).matches()) continue;
            result.add(tableName);
        }
        return result.toArray(new TableName[result.size()]);
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames(pattern);
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames(regex);
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables(regex);
    }

    public TableName[] listTableNames() throws IOException {
        return this.asTableNames(this.requestTableList().getTablesList());
    }

    private ListTablesResponse requestTableList() throws IOException {
        try {
            ListTablesRequest.Builder builder = ListTablesRequest.newBuilder();
            builder.setParent(this.bigtableInstanceName.toString());
            return this.bigtableTableAdminClient.listTables(builder.build());
        }
        catch (Throwable throwable) {
            throw new IOException("Failed to listTables", throwable);
        }
    }

    private TableName[] asTableNames(List<Table> tablesList) {
        TableName[] result = new TableName[tablesList.size()];
        for (int i = 0; i < tablesList.size(); ++i) {
            String bigtableFullTableName = tablesList.get(i).getName();
            String name = this.bigtableInstanceName.toTableId(bigtableFullTableName);
            result[i] = TableName.valueOf((String)name);
        }
        return result;
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        if (tableName == null) {
            return null;
        }
        String bigtableTableName = this.toBigtableName(tableName);
        GetTableRequest request = GetTableRequest.newBuilder().setName(bigtableTableName).build();
        try {
            return this.tableAdapter.adapt(this.bigtableTableAdminClient.getTable(request));
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.NOT_FOUND.getCode()) {
                throw new TableNotFoundException(tableName);
            }
            throw new IOException("Failed to getTableDescriptor() on " + tableName, e);
        }
        catch (UncheckedExecutionException e) {
            Status status;
            if (e.getCause() != null && e.getCause() instanceof StatusRuntimeException && (status = ((StatusRuntimeException)e.getCause()).getStatus()).getCode() == Status.NOT_FOUND.getCode()) {
                throw new TableNotFoundException(tableName);
            }
            throw new IOException("Failed to getTableDescriptor() on " + tableName, e);
        }
        catch (Throwable throwable) {
            throw new IOException("Failed to getTableDescriptor() on " + tableName, throwable);
        }
    }

    @Deprecated
    public String[] getTableNames(String regex) throws IOException {
        HTableDescriptor[] tableDescriptors = this.listTables(regex);
        String[] tableNames = new String[tableDescriptors.length];
        for (int i = 0; i < tableDescriptors.length; ++i) {
            tableNames[i] = tableDescriptors[i].getNameAsString();
        }
        return tableNames;
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        CreateTableRequest.Builder builder = CreateTableRequest.newBuilder();
        builder.setParent(this.bigtableInstanceName.toString());
        builder.setTableId(desc.getTableName().getQualifierAsString());
        builder.setTable(this.tableAdapter.adapt(desc));
        if (splitKeys != null) {
            for (byte[] splitKey : splitKeys) {
                builder.addInitialSplits(CreateTableRequest.Split.newBuilder().setKey(ByteString.copyFrom(splitKey)).build());
            }
        }
        try {
            this.bigtableTableAdminClient.createTable(builder.build());
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to create table '%s'", desc.getTableName().getNameAsString()), throwable);
        }
    }

    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        LOG.warn("Creating the table synchronously", new Object[0]);
        this.createTable(desc, splitKeys);
    }

    public void deleteTable(TableName tableName) throws IOException {
        DeleteTableRequest.Builder deleteBuilder = DeleteTableRequest.newBuilder();
        deleteBuilder.setName(this.toBigtableName(tableName));
        try {
            this.bigtableTableAdminClient.deleteTable(deleteBuilder.build());
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to delete table '%s'", tableName.getNameAsString()), throwable);
        }
        this.disabledTables.remove(tableName);
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            try {
                this.deleteTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info("Failed to delete table " + table.getTableName(), ex, new Object[0]);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void enableTable(TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
        this.disabledTables.remove(tableName);
        LOG.warn("Table " + tableName + " was enabled in memory only.", new Object[0]);
    }

    @Deprecated
    public void enableTable(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        this.enableTable(tableName);
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(regex)) {
            this.enableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(pattern)) {
            this.enableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        this.disableTable(tableName);
    }

    public void disableTable(TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
        if (this.isTableDisabled(tableName)) {
            throw new TableNotEnabledException(tableName);
        }
        this.disabledTables.add(tableName);
        LOG.warn("Table " + tableName + " was disabled in memory only.", new Object[0]);
    }

    @Deprecated
    public void disableTable(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(regex)) {
            this.disableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(pattern)) {
            this.disableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return !this.isTableDisabled(tableName);
    }

    @Deprecated
    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.disabledTables.contains(tableName);
    }

    @Deprecated
    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.tableExists(tableName);
    }

    public void addColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        String columnName = column.getNameAsString();
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(columnName).setCreate(this.columnDescriptorAdapter.adapt(column).build());
        this.modifyColumn(tableName, columnName, "add", modification);
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        String columnName = column.getNameAsString();
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(columnName).setUpdate(this.columnDescriptorAdapter.adapt(column).build());
        this.modifyColumn(tableName, columnName, "update", modification);
    }

    public void deleteColumn(TableName tableName, byte[] columnName) throws IOException {
        String columnNameStr = Bytes.toString((byte[])columnName);
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(columnNameStr).setDrop(true);
        this.modifyColumn(tableName, columnNameStr, "delete", modification);
    }

    protected void modifyColumn(TableName tableName, String columnName, String modificationType, ModifyColumnFamiliesRequest.Modification.Builder modification) throws IOException {
        ModifyColumnFamiliesRequest.Builder modifyColumnBuilder = ModifyColumnFamiliesRequest.newBuilder().addModifications(modification).setName(this.toBigtableName(tableName));
        try {
            this.bigtableTableAdminClient.modifyColumnFamily(modifyColumnBuilder.build());
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to %d column '%s' in table '%s'", modificationType, columnName, tableName.getNameAsString()), throwable);
        }
    }

    @Deprecated
    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((String)tableName), column);
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((String)tableName), descriptor);
    }

    @Deprecated
    public void deleteColumn(String tableName, byte[] columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), columnName);
    }

    @Deprecated
    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), Bytes.toBytes((String)columnName));
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return new ClusterStatus(){

            public Collection<ServerName> getServers() {
                return Collections.emptyList();
            }
        };
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        ArrayList<HRegionInfo> regionInfos = new ArrayList<HRegionInfo>();
        for (HRegionLocation location : this.connection.getRegionLocator(tableName).getAllRegionLocations()) {
            regionInfos.add(location.getRegionInfo());
        }
        return regionInfos;
    }

    public void close() throws IOException {
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        TableName[] tableNameArray = tableNames.toArray(new TableName[tableNames.size()]);
        return this.getTableDescriptors(tableNameArray);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("project", this.options.getProjectId()).add("instance", this.options.getInstanceId()).add("adminHost", this.options.getTableAdminHost()).toString();
    }

    public int getOperationTimeout() {
        throw new UnsupportedOperationException("getOperationTimeout");
    }

    public void abort(String why, Throwable e) {
        throw new UnsupportedOperationException("abort");
    }

    public boolean isAborted() {
        throw new UnsupportedOperationException("isAborted");
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        if (!preserveSplits) {
            LOG.info("truncate will preserveSplits. The passed in variable is ignored.", new Object[0]);
        }
        this.issueBulkDelete(tableName, DropRowRangeRequest.newBuilder().setDeleteAllDataFromTable(true));
        this.disabledTables.remove(tableName);
    }

    public void deleteRowRangeByPrefix(TableName tableName, byte[] prefix) throws IOException {
        this.issueBulkDelete(tableName, DropRowRangeRequest.newBuilder().setDeleteAllDataFromTable(false).setRowKeyPrefix(ByteString.copyFrom(prefix)));
    }

    private void issueBulkDelete(TableName tableName, DropRowRangeRequest.Builder deleteRequest) throws IOException {
        try {
            this.bigtableTableAdminClient.dropRowRange(deleteRequest.setName(this.toBigtableName(tableName)).build());
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to truncate table '%s'", tableName.getNameAsString()), throwable);
        }
    }

    protected String toBigtableName(TableName tableName) {
        return this.bigtableInstanceName.toTableNameStr(tableName.getNameAsString());
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.tableExists(tableName);
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return new Pair((Object)0, (Object)0);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf((byte[])tableName));
    }

    public Pair<Integer, Integer> getAlterStatus(String tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf((String)tableName));
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegion");
    }

    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegion");
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegionWithEncodedRegionName");
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        throw new UnsupportedOperationException("closeRegion");
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        throw new UnsupportedOperationException("getOnlineRegions");
    }

    public void flush(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("flush");
    }

    public void flushRegion(byte[] bytes) throws IOException {
        LOG.info("flushRegion is a no-op", new Object[0]);
    }

    public void compact(TableName tableName) throws IOException {
        LOG.info("compact is a no-op", new Object[0]);
    }

    public void compactRegion(byte[] bytes) throws IOException {
        LOG.info("compactRegion is a no-op", new Object[0]);
    }

    public void compact(TableName tableName, byte[] bytes) throws IOException {
        LOG.info("compact is a no-op", new Object[0]);
    }

    public void compactRegion(byte[] bytes, byte[] bytes2) throws IOException {
        LOG.info("compactRegion is a no-op", new Object[0]);
    }

    public void majorCompact(TableName tableName) throws IOException {
        LOG.info("majorCompact is a no-op", new Object[0]);
    }

    public void majorCompactRegion(byte[] bytes) throws IOException {
        LOG.info("majorCompactRegion is a no-op", new Object[0]);
    }

    public void majorCompact(TableName tableName, byte[] bytes) throws IOException {
        LOG.info("majorCompact is a no-op", new Object[0]);
    }

    public void majorCompactRegion(byte[] bytes, byte[] bytes2) throws IOException {
        LOG.info("majorCompactRegion is a no-op", new Object[0]);
    }

    public void compactRegionServer(ServerName serverName, boolean b) throws IOException {
        LOG.info("compactRegionServer is a no-op", new Object[0]);
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws HBaseIOException, MasterNotRunningException, ZooKeeperConnectionException {
        LOG.info("move is a no-op", new Object[0]);
    }

    public void assign(byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        LOG.info("assign is a no-op", new Object[0]);
    }

    public void unassign(byte[] regionName, boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        LOG.info("unassign is a no-op", new Object[0]);
    }

    public void offline(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("offline");
    }

    public boolean setBalancerRunning(boolean on, boolean synchronous) throws MasterNotRunningException, ZooKeeperConnectionException {
        throw new UnsupportedOperationException("setBalancerRunning");
    }

    public boolean balancer() throws MasterNotRunningException, ZooKeeperConnectionException {
        throw new UnsupportedOperationException("balancer");
    }

    public boolean enableCatalogJanitor(boolean enable) throws MasterNotRunningException {
        throw new UnsupportedOperationException("enableCatalogJanitor");
    }

    public int runCatalogScan() throws MasterNotRunningException {
        throw new UnsupportedOperationException("runCatalogScan");
    }

    public boolean isCatalogJanitorEnabled() throws MasterNotRunningException {
        throw new UnsupportedOperationException("isCatalogJanitorEnabled");
    }

    public void mergeRegions(byte[] encodedNameOfRegionA, byte[] encodedNameOfRegionB, boolean forcible) throws IOException {
        LOG.info("mergeRegions is a no-op", new Object[0]);
    }

    public void split(TableName tableName) throws IOException {
        LOG.info("split is a no-op", new Object[0]);
    }

    public void splitRegion(byte[] bytes) throws IOException {
        LOG.info("splitRegion is a no-op", new Object[0]);
    }

    public void split(TableName tableName, byte[] bytes) throws IOException {
        LOG.info("split is a no-op", new Object[0]);
    }

    public void splitRegion(byte[] bytes, byte[] bytes2) throws IOException {
        LOG.info("split is a no-op", new Object[0]);
    }

    public void modifyTable(TableName tableName, HTableDescriptor htd) throws IOException {
        throw new UnsupportedOperationException("modifyTable");
    }

    public void shutdown() throws IOException {
        throw new UnsupportedOperationException("shutdown");
    }

    public void stopMaster() throws IOException {
        throw new UnsupportedOperationException("stopMaster");
    }

    public void stopRegionServer(String hostnamePort) throws IOException {
        throw new UnsupportedOperationException("stopRegionServer");
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        throw new UnsupportedOperationException("createNamespace");
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        throw new UnsupportedOperationException("modifyNamespace");
    }

    public void deleteNamespace(String name) throws IOException {
        throw new UnsupportedOperationException("deleteNamespace");
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws IOException {
        throw new UnsupportedOperationException("getNamespaceDescriptor");
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        throw new UnsupportedOperationException("listNamespaceDescriptors");
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        throw new UnsupportedOperationException("listDescriptorsByNamespace");
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        throw new UnsupportedOperationException("listTableNamesByNamespace");
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        throw new UnsupportedOperationException("getTableDescriptors");
    }

    public String[] getMasterCoprocessors() {
        throw new UnsupportedOperationException("getMasterCoprocessors");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getCompactionState");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] bytes) throws IOException {
        throw new UnsupportedOperationException("getCompactionStateForRegion");
    }

    public void snapshot(String snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot");
    }

    public void snapshot(byte[] snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot");
    }

    public void snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot");
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot");
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        throw new UnsupportedOperationException("takeSnapshotAsync");
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        throw new UnsupportedOperationException("isSnapshotFinished");
    }

    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        throw new UnsupportedOperationException("cloneSnapshot");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        throw new UnsupportedOperationException("cloneSnapshot");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedure");
    }

    public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedureWithRet");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("isProcedureFinished");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        throw new UnsupportedOperationException("listSnapshots");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
        throw new UnsupportedOperationException("listSnapshots");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("listSnapshots");
    }

    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshot");
    }

    public void deleteSnapshot(String snapshotName) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshot");
    }

    public void deleteSnapshots(String regex) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshots");
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshots");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        throw new UnsupportedOperationException("coprocessorService");
    }

    public void updateConfiguration(ServerName serverName) throws IOException {
        throw new UnsupportedOperationException("updateConfiguration");
    }

    public void updateConfiguration() throws IOException {
        throw new UnsupportedOperationException("updateConfiguration");
    }

    public int getMasterInfoPort() throws IOException {
        throw new UnsupportedOperationException("getMasterInfoPort");
    }

    public void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        throw new UnsupportedOperationException("rollWALWriter");
    }
}

