/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.async.AsyncExecutor;
import com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;

public class BigtableBufferedMutatorHelper {
    protected static final Logger LOG = new Logger(BigtableBufferedMutatorHelper.class);
    private final Configuration configuration;
    private final ReentrantReadWriteLock isClosedLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock closedReadLock = this.isClosedLock.readLock();
    private final ReentrantReadWriteLock.WriteLock closedWriteLock = this.isClosedLock.writeLock();
    private boolean closed = false;
    private final HBaseRequestAdapter adapter;
    private final AsyncExecutor asyncExecutor;
    private BulkMutation bulkMutation = null;
    private BigtableOptions options;

    public BigtableBufferedMutatorHelper(HBaseRequestAdapter adapter, Configuration configuration, BigtableSession session) {
        this.adapter = adapter;
        this.configuration = configuration;
        this.options = session.getOptions();
        this.asyncExecutor = session.createAsyncExecutor();
        BigtableTableName tableName = this.adapter.getBigtableTableName();
        this.bulkMutation = session.createBulkMutation(tableName);
    }

    public void close() throws IOException {
        this.closedWriteLock.lock();
        try {
            this.flush();
            this.asyncExecutor.flush();
            this.closed = true;
        }
        finally {
            this.closedWriteLock.unlock();
        }
    }

    public void flush() throws IOException {
        if (this.bulkMutation != null) {
            try {
                this.bulkMutation.flush();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("flush() was interrupted", e);
            }
        }
        this.asyncExecutor.flush();
    }

    public void sendUnsent() {
        if (this.bulkMutation != null) {
            this.bulkMutation.sendUnsent();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TableName getName() {
        return this.adapter.getTableName();
    }

    public long getWriteBufferSize() {
        return this.options.getBulkOptions().getMaxMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ListenableFuture<?>> mutate(List<? extends Mutation> mutations) {
        this.closedReadLock.lock();
        try {
            ArrayList futures = new ArrayList(mutations.size());
            for (Mutation mutation : mutations) {
                futures.add(this.offer(mutation));
            }
            ArrayList<ListenableFuture<?>> arrayList = futures;
            return arrayList;
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    public ListenableFuture<?> mutate(Mutation mutation) {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            ListenableFuture<?> listenableFuture = this.offer(mutation);
            return listenableFuture;
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    private ListenableFuture<?> offer(Mutation mutation) {
        if (this.closed) {
            Futures.immediateFailedFuture((Throwable)new IllegalStateException("Cannot mutate when the BufferedMutator is closed."));
        }
        ListenableFuture future = null;
        try {
            future = mutation == null ? Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("Cannot perform a mutation on a null object.")) : (mutation instanceof Put ? this.bulkMutation.add(this.adapter.adaptEntry((Put)mutation)) : (mutation instanceof Delete ? this.bulkMutation.add(this.adapter.adaptEntry((Delete)mutation)) : (mutation instanceof Increment ? this.asyncExecutor.readModifyWriteRowAsync(this.adapter.adapt((Increment)mutation)) : (mutation instanceof Append ? this.asyncExecutor.readModifyWriteRowAsync(this.adapter.adapt((Append)mutation)) : Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("Encountered unknown mutation type: " + mutation.getClass()))))));
        }
        catch (Exception e) {
            future = Futures.immediateFailedFuture((Throwable)e);
        }
        return future;
    }

    public boolean hasInflightRequests() {
        return this.asyncExecutor.hasInflightRequests() || this.bulkMutation != null && !this.bulkMutation.isFlushed();
    }
}

