/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRule;
import com.google.cloud.bigtable.hbase.adapters.CellDeduplicationHelper;
import com.google.cloud.bigtable.hbase.adapters.OperationAdapter;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

public class AppendAdapter
implements OperationAdapter<Append, ReadModifyWriteRowRequest.Builder> {
    @Override
    public ReadModifyWriteRowRequest.Builder adapt(Append operation) {
        ReadModifyWriteRowRequest.Builder result = ReadModifyWriteRowRequest.newBuilder();
        result.setRowKey(ByteString.copyFrom((byte[])operation.getRow()));
        for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
            String familyName = Bytes.toString((byte[])((byte[])entry.getKey()));
            List<Cell> cells = CellDeduplicationHelper.deduplicateFamily((Mutation)operation, (byte[])entry.getKey());
            for (Cell cell : cells) {
                ReadModifyWriteRule.Builder rule = ReadModifyWriteRule.newBuilder();
                rule.setFamilyName(familyName);
                rule.setColumnQualifier(ByteString.copyFrom((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
                rule.setAppendValue(ByteString.copyFrom((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                result.addRules(rule.build());
            }
        }
        return result;
    }
}

