/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ValueFilter;

public class CheckAndMutateUtil {
    private static final ReadHooks UNSUPPORTED_READ_HOOKS = new ReadHooks(){

        @Override
        public void composePreSendHook(Function<ReadRowsRequest, ReadRowsRequest> newHook) {
            throw new IllegalStateException("We built a bad Filter for conditional mutation.");
        }

        @Override
        public ReadRowsRequest applyPreSendHook(ReadRowsRequest readRowsRequest) {
            throw new UnsupportedOperationException("We built a bad Filter for conditional mutation.");
        }
    };

    public static boolean wasMutationApplied(CheckAndMutateRowRequest request, CheckAndMutateRowResponse response) {
        return request.getTrueMutationsCount() > 0 && response.getPredicateMatched() || request.getFalseMutationsCount() > 0 && !response.getPredicateMatched();
    }

    private static CompareFilter.CompareOp reverseCompareOp(CompareFilter.CompareOp compareOp) {
        switch (compareOp) {
            case EQUAL: 
            case NOT_EQUAL: 
            case NO_OP: {
                return compareOp;
            }
            case LESS: {
                return CompareFilter.CompareOp.GREATER;
            }
            case LESS_OR_EQUAL: {
                return CompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return CompareFilter.CompareOp.LESS;
            }
            case GREATER_OR_EQUAL: {
                return CompareFilter.CompareOp.LESS_OR_EQUAL;
            }
        }
        return CompareFilter.CompareOp.NO_OP;
    }

    public static class RequestBuilder {
        private final HBaseRequestAdapter hbaseAdapter;
        private final CheckAndMutateRowRequest.Builder requestBuilder;
        private final List<Mutation> mutations = new ArrayList<Mutation>();
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private CompareFilter.CompareOp compareOp;
        private byte[] value;
        private boolean checkNonExistence = false;

        public RequestBuilder(HBaseRequestAdapter hbaseAdapter, byte[] row, byte[] family) {
            this.row = (byte[])Preconditions.checkNotNull((Object)row, (Object)"row is null");
            this.family = (byte[])Preconditions.checkNotNull((Object)family, (Object)"family is null");
            this.requestBuilder = CheckAndMutateRowRequest.newBuilder().setRowKey(ByteString.copyFrom((byte[])row)).setTableName(hbaseAdapter.getBigtableTableName().toString());
            this.hbaseAdapter = hbaseAdapter.withServerSideTimestamps();
        }

        public RequestBuilder qualifier(byte[] qualifier) {
            this.qualifier = (byte[])Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier is null. Consider using an empty byte array, or just do not call this method if you want a null qualifier");
            return this;
        }

        public RequestBuilder ifNotExists() {
            Preconditions.checkState((this.compareOp == null ? 1 : 0) != 0, (Object)"ifNotExists and ifMatches are mutually exclusive");
            this.checkNonExistence = true;
            return this;
        }

        public RequestBuilder ifMatches(CompareFilter.CompareOp compareOp, @Nullable byte[] value) {
            Preconditions.checkState((!this.checkNonExistence ? 1 : 0) != 0, (Object)"ifNotExists and ifMatches are mutually exclusive");
            this.compareOp = (CompareFilter.CompareOp)Preconditions.checkNotNull((Object)compareOp, (Object)"compareOp is null");
            this.value = value;
            return this;
        }

        public RequestBuilder withPut(Put put) throws DoNotRetryIOException {
            return this.addMutations(put.getRow(), this.hbaseAdapter.adapt(put).getMutationsList());
        }

        public RequestBuilder withDelete(Delete delete) throws DoNotRetryIOException {
            return this.addMutations(delete.getRow(), this.hbaseAdapter.adapt(delete).getMutationsList());
        }

        public RequestBuilder withMutations(RowMutations rm) throws DoNotRetryIOException {
            return this.addMutations(rm.getRow(), this.hbaseAdapter.adapt(rm).getMutationsList());
        }

        private RequestBuilder addMutations(byte[] actionRow, List<Mutation> mutations) throws DoNotRetryIOException {
            if (!Arrays.equals(actionRow, this.row)) {
                throw new DoNotRetryIOException("Action's getRow must match the passed row");
            }
            this.mutations.addAll(mutations);
            return this;
        }

        public CheckAndMutateRowRequest build() {
            Preconditions.checkState((this.checkNonExistence || this.compareOp != null ? 1 : 0) != 0, (Object)"condition is null. You need to specify the condition by calling ifNotExists/ifEquals/ifMatches before executing the request");
            Scan scan = new Scan();
            scan.setMaxVersions(1);
            scan.addColumn(this.family, this.qualifier);
            if (this.value == null || this.checkNonExistence) {
                if (CompareFilter.CompareOp.NOT_EQUAL.equals((Object)this.compareOp)) {
                    this.requestBuilder.addAllTrueMutations(this.mutations);
                } else {
                    this.requestBuilder.addAllFalseMutations(this.mutations);
                }
            } else {
                ValueFilter valueFilter = new ValueFilter(CheckAndMutateUtil.reverseCompareOp(this.compareOp), (ByteArrayComparable)new BinaryComparator(this.value));
                scan.setFilter((Filter)valueFilter);
                this.requestBuilder.addAllTrueMutations(this.mutations);
            }
            this.requestBuilder.setPredicateFilter(Adapters.SCAN_ADAPTER.buildFilter(scan, UNSUPPORTED_READ_HOOKS));
            return this.requestBuilder.build();
        }
    }
}

