/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRule;
import com.google.cloud.bigtable.hbase.adapters.CellDeduplicationHelper;
import com.google.cloud.bigtable.hbase.adapters.OperationAdapter;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

public class IncrementAdapter
implements OperationAdapter<Increment, ReadModifyWriteRowRequest.Builder> {
    @Override
    public ReadModifyWriteRowRequest.Builder adapt(Increment operation) {
        if (!operation.getTimeRange().isAllTime()) {
            throw new UnsupportedOperationException("Setting the time range in an Increment is not implemented");
        }
        ReadModifyWriteRowRequest.Builder result = ReadModifyWriteRowRequest.newBuilder();
        result.setRowKey(ByteString.copyFrom((byte[])operation.getRow()));
        for (Map.Entry familyEntry : operation.getFamilyMapOfLongs().entrySet()) {
            String familyName = Bytes.toString((byte[])((byte[])familyEntry.getKey()));
            List<Cell> mutationCells = CellDeduplicationHelper.deduplicateFamily((Mutation)operation, (byte[])familyEntry.getKey());
            for (Cell cell : mutationCells) {
                ReadModifyWriteRule.Builder rule = ReadModifyWriteRule.newBuilder();
                rule.setIncrementAmount(Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                rule.setFamilyName(familyName);
                rule.setColumnQualifier(ByteString.copyFrom((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
                result.addRules(rule.build());
            }
        }
        return result;
    }
}

