/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.admin;

import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.GcRule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;

public class ColumnDescriptorAdapter {
    public static final Set<String> SUPPORTED_OPTION_KEYS = ImmutableSet.of((Object)"MIN_VERSIONS", (Object)"TTL", (Object)"VERSIONS");
    public static final Set<String> IGNORED_OPTION_KEYS = ImmutableSet.of((Object)"COMPRESSION", (Object)"COMPRESSION_COMPACT", (Object)"DATA_BLOCK_ENCODING", (Object)"BLOCKCACHE", (Object)"CACHE_DATA_ON_WRITE", (Object)"CACHE_INDEX_ON_WRITE", (Object[])new String[]{"CACHE_BLOOMS_ON_WRITE", "EVICT_BLOCKS_ON_CLOSE", "CACHE_DATA_IN_L1", "PREFETCH_BLOCKS_ON_OPEN", "BLOCKSIZE", "BLOOMFILTER", "REPLICATION_SCOPE", "IN_MEMORY"});
    public static final Map<String, String> SUPPORTED_OPTION_VALUES = ImmutableMap.of((Object)"KEEP_DELETED_CELLS", (Object)Boolean.toString(false), (Object)"COMPRESS_TAGS", (Object)Boolean.toString(false));

    public static List<String> getUnknownFeatures(HColumnDescriptor columnDescriptor) {
        ArrayList<String> unknownFeatures = new ArrayList<String>();
        for (Map.Entry entry : columnDescriptor.getConfiguration().entrySet()) {
            String key = (String)entry.getKey();
            if (SUPPORTED_OPTION_KEYS.contains(key) || IGNORED_OPTION_KEYS.contains(key) || SUPPORTED_OPTION_VALUES.containsKey(key)) continue;
            unknownFeatures.add(key);
        }
        return unknownFeatures;
    }

    public static Map<String, String> getUnsupportedFeatures(HColumnDescriptor columnDescriptor) {
        HashMap<String, String> unsupportedConfiguration = new HashMap<String, String>();
        Map configuration = columnDescriptor.getConfiguration();
        for (Map.Entry<String, String> entry : SUPPORTED_OPTION_VALUES.entrySet()) {
            if (!configuration.containsKey(entry.getKey()) || configuration.get(entry.getKey()) == null || entry.getValue().equals(configuration.get(entry.getKey()))) continue;
            unsupportedConfiguration.put(entry.getKey(), (String)configuration.get(entry.getKey()));
        }
        return unsupportedConfiguration;
    }

    public static void throwIfRequestingUnknownFeatures(HColumnDescriptor columnDescriptor) {
        List<String> unknownFeatures = ColumnDescriptorAdapter.getUnknownFeatures(columnDescriptor);
        if (!unknownFeatures.isEmpty()) {
            String featureString = String.format("Unknown configuration options: [%s]", Joiner.on((String)", ").join(unknownFeatures));
            throw new UnsupportedOperationException(featureString);
        }
    }

    public static void throwIfRequestingUnsupportedFeatures(HColumnDescriptor columnDescriptor) {
        Map<String, String> unsupportedConfiguration = ColumnDescriptorAdapter.getUnsupportedFeatures(columnDescriptor);
        if (!unsupportedConfiguration.isEmpty()) {
            ArrayList<String> configurationStrings = new ArrayList<String>(unsupportedConfiguration.size());
            for (Map.Entry<String, String> entry : unsupportedConfiguration.entrySet()) {
                configurationStrings.add(String.format("(%s: %s)", entry.getKey(), entry.getValue()));
            }
            String exceptionMessage = String.format("Unsupported configuration options: %s", Joiner.on((String)",").join(configurationStrings));
            throw new UnsupportedOperationException(exceptionMessage);
        }
    }

    public static GcRule buildGarbageCollectionRule(HColumnDescriptor columnDescriptor) {
        int maxVersions = columnDescriptor.getMaxVersions();
        int minVersions = columnDescriptor.getMinVersions();
        int ttlSeconds = columnDescriptor.getTimeToLive();
        Preconditions.checkState((minVersions < maxVersions ? 1 : 0) != 0, (Object)"HColumnDescriptor min versions must be less than max versions.");
        if (ttlSeconds == Integer.MAX_VALUE) {
            if (maxVersions == Integer.MAX_VALUE) {
                return null;
            }
            return ColumnDescriptorAdapter.maxVersions(maxVersions);
        }
        GcRule ageRule = ColumnDescriptorAdapter.maxAge(ttlSeconds);
        if (minVersions != 0) {
            ageRule = ColumnDescriptorAdapter.intersection(ageRule, ColumnDescriptorAdapter.maxVersions(minVersions));
        }
        if (maxVersions == Integer.MAX_VALUE) {
            return ageRule;
        }
        return ColumnDescriptorAdapter.union(ageRule, ColumnDescriptorAdapter.maxVersions(maxVersions));
    }

    @VisibleForTesting
    static GcRule intersection(GcRule ... rules) {
        return GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addAllRules(Arrays.asList(rules)).build()).build();
    }

    @VisibleForTesting
    static GcRule union(GcRule ... rules) {
        return GcRule.newBuilder().setUnion(GcRule.Union.newBuilder().addAllRules(Arrays.asList(rules)).build()).build();
    }

    private static Duration duration(int ttlSeconds) {
        return Duration.newBuilder().setSeconds((long)ttlSeconds).build();
    }

    @VisibleForTesting
    static GcRule maxAge(int ttlSeconds) {
        return GcRule.newBuilder().setMaxAge(ColumnDescriptorAdapter.duration(ttlSeconds)).build();
    }

    @VisibleForTesting
    static GcRule maxVersions(int maxVersions) {
        return GcRule.newBuilder().setMaxNumVersions(maxVersions).build();
    }

    private static void convertGarbageCollectionRule(GcRule gcRule, HColumnDescriptor columnDescriptor) {
        columnDescriptor.setMaxVersions(Integer.MAX_VALUE);
        if (gcRule == null || gcRule.equals((Object)GcRule.getDefaultInstance())) {
            return;
        }
        switch (gcRule.getRuleCase()) {
            case MAX_AGE: {
                columnDescriptor.setTimeToLive((int)gcRule.getMaxAge().getSeconds());
                return;
            }
            case MAX_NUM_VERSIONS: {
                columnDescriptor.setMaxVersions(gcRule.getMaxNumVersions());
                return;
            }
            case INTERSECTION: {
                ColumnDescriptorAdapter.processIntersection(gcRule, columnDescriptor);
                return;
            }
            case UNION: {
                List unionRules = gcRule.getUnion().getRulesList();
                Preconditions.checkArgument((unionRules.size() == 2 ? 1 : 0) != 0, (Object)("Cannot process rule " + gcRule));
                if (ColumnDescriptorAdapter.hasRule(unionRules, GcRule.RuleCase.INTERSECTION)) {
                    ColumnDescriptorAdapter.processIntersection(ColumnDescriptorAdapter.getRule(unionRules, GcRule.RuleCase.INTERSECTION), columnDescriptor);
                } else {
                    columnDescriptor.setTimeToLive((int)ColumnDescriptorAdapter.getRule(unionRules, GcRule.RuleCase.MAX_AGE).getMaxAge().getSeconds());
                }
                columnDescriptor.setMaxVersions(ColumnDescriptorAdapter.getVersionCount(unionRules));
                return;
            }
        }
        throw new IllegalArgumentException("Could not proess gc rules: " + gcRule);
    }

    protected static void processIntersection(GcRule gcRule, HColumnDescriptor columnDescriptor) {
        List intersectionRules = gcRule.getIntersection().getRulesList();
        Preconditions.checkArgument((intersectionRules.size() == 2 ? 1 : 0) != 0, (Object)("Cannot process rule " + gcRule));
        columnDescriptor.setMinVersions(ColumnDescriptorAdapter.getVersionCount(intersectionRules));
        columnDescriptor.setTimeToLive(ColumnDescriptorAdapter.getTtl(intersectionRules));
    }

    private static int getVersionCount(List<GcRule> intersectionRules) {
        return ColumnDescriptorAdapter.getRule(intersectionRules, GcRule.RuleCase.MAX_NUM_VERSIONS).getMaxNumVersions();
    }

    private static int getTtl(List<GcRule> intersectionRules) {
        return (int)ColumnDescriptorAdapter.getRule(intersectionRules, GcRule.RuleCase.MAX_AGE).getMaxAge().getSeconds();
    }

    private static GcRule getRule(List<GcRule> intersectionRules, GcRule.RuleCase ruleCase) {
        for (GcRule gcRule : intersectionRules) {
            if (gcRule.getRuleCase() != ruleCase) continue;
            return gcRule;
        }
        throw new IllegalStateException("Could not get process: " + intersectionRules);
    }

    private static boolean hasRule(List<GcRule> intersectionRules, GcRule.RuleCase ruleCase) {
        for (GcRule gcRule : intersectionRules) {
            if (gcRule.getRuleCase() != ruleCase) continue;
            return true;
        }
        return false;
    }

    public ColumnFamily.Builder adapt(HColumnDescriptor columnDescriptor) {
        ColumnDescriptorAdapter.throwIfRequestingUnknownFeatures(columnDescriptor);
        ColumnDescriptorAdapter.throwIfRequestingUnsupportedFeatures(columnDescriptor);
        ColumnFamily.Builder resultBuilder = ColumnFamily.newBuilder();
        GcRule gcRule = ColumnDescriptorAdapter.buildGarbageCollectionRule(columnDescriptor);
        if (gcRule != null) {
            resultBuilder.setGcRule(gcRule);
        }
        return resultBuilder;
    }

    public HColumnDescriptor adapt(String familyName, ColumnFamily columnFamily) {
        HColumnDescriptor hColumnDescriptor = new HColumnDescriptor(familyName);
        ColumnDescriptorAdapter.convertGarbageCollectionRule(columnFamily.getGcRule(), hColumnDescriptor);
        return hColumnDescriptor;
    }
}

