/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.admin;

import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.cloud.bigtable.hbase.adapters.admin.ColumnDescriptorAdapter;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;

public class TableAdapter {
    protected final BigtableInstanceName bigtableInstanceName;
    protected final ColumnDescriptorAdapter columnDescriptorAdapter;

    public TableAdapter(BigtableInstanceName bigtableInstanceName, ColumnDescriptorAdapter columnDescriptorAdapter) {
        this.bigtableInstanceName = bigtableInstanceName;
        this.columnDescriptorAdapter = columnDescriptorAdapter;
    }

    protected Table adapt(HTableDescriptor desc) {
        HashMap<String, ColumnFamily> columnFamilies = new HashMap<String, ColumnFamily>();
        for (HColumnDescriptor column : desc.getColumnFamilies()) {
            String columnName = column.getNameAsString();
            ColumnFamily columnFamily = this.columnDescriptorAdapter.adapt(column).build();
            columnFamilies.put(columnName, columnFamily);
        }
        return Table.newBuilder().putAllColumnFamilies(columnFamilies).build();
    }

    public CreateTableRequest.Builder adapt(HTableDescriptor desc, byte[][] splitKeys) {
        CreateTableRequest.Builder builder = CreateTableRequest.newBuilder();
        builder.setTableId(desc.getTableName().getQualifierAsString());
        builder.setTable(this.adapt(desc));
        TableAdapter.addSplitKeys(builder, splitKeys);
        return builder;
    }

    public static void addSplitKeys(CreateTableRequest.Builder builder, byte[][] splitKeys) {
        if (splitKeys != null) {
            for (byte[] splitKey : splitKeys) {
                builder.addInitialSplits(CreateTableRequest.Split.newBuilder().setKey(ByteString.copyFrom((byte[])splitKey)).build());
            }
        }
    }

    public HTableDescriptor adapt(Table table) {
        String tableId = this.bigtableInstanceName.toTableId(table.getName());
        HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((String)tableId));
        for (Map.Entry entry : table.getColumnFamiliesMap().entrySet()) {
            tableDescriptor.addFamily(this.columnDescriptorAdapter.adapt((String)entry.getKey(), (ColumnFamily)entry.getValue()));
        }
        return tableDescriptor;
    }
}

