/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.hbase.adapters.ResponseAdapter;
import com.google.common.base.Throwables;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.io.IOException;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;

public class BigtableWhileMatchResultScannerAdapter {
    private static final String WHILE_MATCH_FILTER_IN_LABEL_SUFFIX = "-in";
    private static final String WHILE_MATCH_FILTER_OUT_LABEL_SUFFIX = "-out";
    final ResponseAdapter<FlatRow, Result> rowAdapter;

    public BigtableWhileMatchResultScannerAdapter(ResponseAdapter<FlatRow, Result> rowAdapter) {
        this.rowAdapter = rowAdapter;
    }

    public ResultScanner adapt(final com.google.cloud.bigtable.grpc.scanner.ResultScanner<FlatRow> bigtableResultScanner, final Span span) {
        return new AbstractClientScanner(){

            public Result next() throws IOException {
                FlatRow row = (FlatRow)bigtableResultScanner.next();
                if (row == null) {
                    this.closeSpan();
                    return null;
                }
                if (!BigtableWhileMatchResultScannerAdapter.hasMatchingLabels(row)) {
                    this.close();
                    return null;
                }
                return BigtableWhileMatchResultScannerAdapter.this.rowAdapter.adaptResponse(row);
            }

            protected void closeSpan() {
                try (Scope c = Tracing.getTracer().withSpan(span);){
                    span.end();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void close() {
                try {
                    bigtableResultScanner.close();
                }
                catch (IOException ioe) {
                    throw Throwables.propagate((Throwable)ioe);
                }
                finally {
                    this.closeSpan();
                }
            }

            public boolean renewLease() {
                throw new UnsupportedOperationException("renewLease");
            }
        };
    }

    public static boolean hasMatchingLabels(FlatRow row) {
        int inLabelCount = 0;
        int outLabelCount = 0;
        for (FlatRow.Cell cell : row.getCells()) {
            for (String label : cell.getLabels()) {
                if (label.endsWith(WHILE_MATCH_FILTER_IN_LABEL_SUFFIX)) {
                    ++inLabelCount;
                    continue;
                }
                if (!label.endsWith(WHILE_MATCH_FILTER_OUT_LABEL_SUFFIX)) continue;
                ++outLabelCount;
            }
        }
        return inLabelCount == outLabelCount;
    }
}

