/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.data.v2.wrappers.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class FuzzyRowFilterAdapter
extends TypedFilterAdapterBase<FuzzyRowFilter> {
    private static final RowFilter ALL_VALUES_FILTER = Filters.FILTERS.pass().toProto();
    private static Field FUZZY_KEY_DATA_FIELD;
    private static Exception FUZZY_KEY_DATA_FIELD_EXCEPTION;

    @Override
    public RowFilter adapt(FilterAdapterContext context, FuzzyRowFilter filter) throws IOException {
        List<Pair<byte[], byte[]>> pairs = FuzzyRowFilterAdapter.extractFuzzyRowFilterPairs(filter);
        if (pairs.isEmpty()) {
            return ALL_VALUES_FILTER;
        }
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        for (Pair<byte[], byte[]> pair : pairs) {
            Preconditions.checkArgument((((byte[])pair.getFirst()).length == ((byte[])pair.getSecond()).length ? 1 : 0) != 0, (Object)"Fuzzy info and match mask must have the same length");
            interleave.filter(FuzzyRowFilterAdapter.createSingleRowFilter((byte[])pair.getFirst(), (byte[])pair.getSecond()));
        }
        new Logger(FuzzyRowFilterAdapter.class).error("Adapted: " + interleave.toProto(), new Object[0]);
        return interleave.toProto();
    }

    private static Filters.Filter createSingleRowFilter(byte[] key, byte[] mask) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(key.length * 2);
        ReaderExpressionHelper.QuoteMetaOutputStream quotingStream = new ReaderExpressionHelper.QuoteMetaOutputStream(baos);
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == -1) {
                quotingStream.write(key[i]);
                continue;
            }
            baos.write(ReaderExpressionHelper.ANY_BYTE_BYTES);
        }
        baos.write(ReaderExpressionHelper.ALL_BYTE_BYTES);
        quotingStream.close();
        return Filters.FILTERS.key().regex(Bytes.toString((byte[])baos.toByteArray()));
    }

    static List<Pair<byte[], byte[]>> extractFuzzyRowFilterPairs(FuzzyRowFilter filter) throws IOException {
        if (FUZZY_KEY_DATA_FIELD_EXCEPTION != null) {
            throw new IOException("Could not read the contents of the FuzzyRowFilter");
        }
        try {
            return (List)FUZZY_KEY_DATA_FIELD.get(filter);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException("Could not read the contents of the FuzzyRowFilter", e);
        }
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, FuzzyRowFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }

    static {
        try {
            FUZZY_KEY_DATA_FIELD = FuzzyRowFilter.class.getDeclaredField("fuzzyKeysData");
            FUZZY_KEY_DATA_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            FUZZY_KEY_DATA_FIELD_EXCEPTION = e;
        }
    }
}

