/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.data.v2.wrappers.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.util.ByteStringer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;

public class MultipleColumnPrefixFilterAdapter
extends TypedFilterAdapterBase<MultipleColumnPrefixFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, MultipleColumnPrefixFilter filter) throws IOException {
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        ByteArrayOutputStream outputStream = null;
        for (byte[] prefix : filter.getPrefix()) {
            if (outputStream == null) {
                outputStream = new ByteArrayOutputStream(prefix.length * 2);
            } else {
                outputStream.reset();
            }
            ReaderExpressionHelper.writeQuotedExpression(outputStream, prefix);
            outputStream.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
            interleave.filter(Filters.FILTERS.qualifier().regex(ByteStringer.wrap((byte[])outputStream.toByteArray())));
        }
        return interleave.toProto();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, MultipleColumnPrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

