/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.data.v2.wrappers.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.util.ByteStringer;
import com.google.cloud.bigtable.util.RowKeyUtil;
import com.google.cloud.bigtable.util.RowKeyWrapper;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.PrefixFilter;

public class PrefixFilterAdapter
extends TypedFilterAdapterBase<PrefixFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, PrefixFilter filter) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(filter.getPrefix().length * 2);
        ReaderExpressionHelper.writeQuotedRegularExpression(baos, filter.getPrefix());
        baos.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
        return Filters.FILTERS.key().regex(ByteStringer.wrap((byte[])baos.toByteArray())).toProto();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, PrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }

    @Override
    public RangeSet<RowKeyWrapper> getIndexScanHint(PrefixFilter filter) {
        if (filter.getPrefix().length == 0) {
            return ImmutableRangeSet.of((Range)Range.all());
        }
        ByteString start = ByteString.copyFrom((byte[])filter.getPrefix());
        ByteString end = ByteString.copyFrom((byte[])RowKeyUtil.calculateTheClosestNextRowKeyForPrefix((byte[])filter.getPrefix()));
        return ImmutableRangeSet.of((Range)Range.closedOpen((Comparable)new RowKeyWrapper(start), (Comparable)new RowKeyWrapper(end)));
    }
}

