/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.data.v2.wrappers.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.util.ByteStringer;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;

public class QualifierFilterAdapter
extends TypedFilterAdapterBase<QualifierFilter> {
    private static final FilterSupportStatus SINGLE_FAMILY_REQUIRED = FilterSupportStatus.newNotSupported("QualifierFilter must have a single column family specified in the Scan when not using CompareOp.EQUAL.");
    private static final FilterSupportStatus UNSUPPORTED_COMPARABLE = FilterSupportStatus.newNotSupported("QualifierFilter must have a BinaryComparator with any CompareOp or a RegexStringComparator with a EQUAL COmpareOp.");

    @Override
    public RowFilter adapt(FilterAdapterContext context, QualifierFilter filter) throws IOException {
        if (filter.getComparator() instanceof RegexStringComparator) {
            return QualifierFilterAdapter.adaptRegexStringComparator(filter.getOperator(), (RegexStringComparator)filter.getComparator()).toProto();
        }
        if (filter.getComparator() instanceof BinaryComparator) {
            return this.adaptBinaryComparator(context, filter.getOperator(), (BinaryComparator)filter.getComparator()).toProto();
        }
        throw new IllegalStateException(String.format("Cannot adapt comparator %s", filter.getComparator().getClass().getCanonicalName()));
    }

    private Filters.Filter adaptBinaryComparator(FilterAdapterContext context, CompareFilter.CompareOp compareOp, BinaryComparator comparator) throws IOException {
        byte[] quoted = ReaderExpressionHelper.quoteRegularExpression(comparator.getValue());
        ByteString quotedValue = ByteStringer.wrap((byte[])quoted);
        switch (compareOp) {
            case LESS: {
                return (Filters.Filter)this.range(context).endOpen((Object)quotedValue);
            }
            case LESS_OR_EQUAL: {
                return (Filters.Filter)this.range(context).endClosed((Object)quotedValue);
            }
            case EQUAL: {
                return Filters.FILTERS.qualifier().regex(quotedValue);
            }
            case NOT_EQUAL: {
                String familyName = QualifierFilterAdapter.getFamily(context);
                return Filters.FILTERS.interleave().filter((Filters.Filter)this.range(familyName).endOpen((Object)quotedValue)).filter((Filters.Filter)this.range(familyName).startOpen((Object)quotedValue));
            }
            case GREATER_OR_EQUAL: {
                return (Filters.Filter)this.range(context).startClosed((Object)quotedValue);
            }
            case GREATER: {
                return (Filters.Filter)this.range(context).startOpen((Object)quotedValue);
            }
            case NO_OP: {
                return Filters.FILTERS.pass();
            }
        }
        throw new IllegalStateException(String.format("Cannot handle unknown compare op %s", compareOp));
    }

    private Filters.QualifierRangeFilter range(FilterAdapterContext context) {
        return this.range(QualifierFilterAdapter.getFamily(context));
    }

    private Filters.QualifierRangeFilter range(String family) {
        return Filters.FILTERS.qualifier().rangeWithinFamily(family);
    }

    private static String getFamily(FilterAdapterContext context) {
        return FilterAdapterHelper.getSingleFamilyName(context);
    }

    private static Filters.Filter adaptRegexStringComparator(CompareFilter.CompareOp compareOp, RegexStringComparator comparator) {
        String pattern = FilterAdapterHelper.extractRegexPattern(comparator);
        switch (compareOp) {
            case EQUAL: {
                return Filters.FILTERS.qualifier().regex(pattern);
            }
            case NO_OP: {
                return Filters.FILTERS.pass();
            }
        }
        throw new IllegalStateException(String.format("Cannot adapt regex filter with compare op %s", compareOp));
    }

    private static boolean isRegexAndSupported(QualifierFilter filter) {
        return filter.getComparator() instanceof RegexStringComparator && CompareFilter.CompareOp.EQUAL.equals((Object)filter.getOperator());
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, QualifierFilter filter) {
        if (!CompareFilter.CompareOp.EQUAL.equals((Object)filter.getOperator()) && filter.getComparator() instanceof BinaryComparator && context.getScan().numFamilies() != 1) {
            return SINGLE_FAMILY_REQUIRED;
        }
        if (!(filter.getComparator() instanceof BinaryComparator) && !QualifierFilterAdapter.isRegexAndSupported(filter)) {
            return UNSUPPORTED_COMPARABLE;
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

