/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.data.v2.wrappers.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.util.ByteStringer;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;

public class RowFilterAdapter
extends TypedFilterAdapterBase<org.apache.hadoop.hbase.filter.RowFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, org.apache.hadoop.hbase.filter.RowFilter filter) throws IOException {
        ByteString regexValue;
        CompareFilter.CompareOp compareOp = filter.getOperator();
        if (compareOp != CompareFilter.CompareOp.EQUAL) {
            throw new IllegalStateException(String.format("Cannot adapt operator %s", compareOp == null ? null : compareOp.getClass().getCanonicalName()));
        }
        ByteArrayComparable comparator = filter.getComparator();
        if (comparator == null) {
            throw new IllegalStateException("Comparator cannot be null");
        }
        if (comparator instanceof RegexStringComparator) {
            regexValue = ByteString.copyFrom((byte[])comparator.getValue());
        } else if (comparator instanceof BinaryComparator) {
            byte[] quotedRegularExpression = ReaderExpressionHelper.quoteRegularExpression(comparator.getValue());
            regexValue = ByteStringer.wrap((byte[])quotedRegularExpression);
        } else {
            throw new IllegalStateException(String.format("Cannot adapt comparator %s", comparator.getClass().getCanonicalName()));
        }
        return Filters.FILTERS.key().regex(regexValue).toProto();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, org.apache.hadoop.hbase.filter.RowFilter filter) {
        ByteArrayComparable comparator = filter.getComparator();
        if (!(comparator instanceof RegexStringComparator) && !(comparator instanceof BinaryComparator)) {
            return FilterSupportStatus.newNotSupported(comparator.getClass().getName() + " comparator is not supported");
        }
        if (filter.getOperator() != CompareFilter.CompareOp.EQUAL) {
            return FilterSupportStatus.newNotSupported(filter.getOperator() + " operator is not supported");
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

