/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.data.v2.wrappers.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.SingleColumnValueFilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class SingleColumnValueExcludeFilterAdapter
extends TypedFilterAdapterBase<SingleColumnValueExcludeFilter> {
    private static final String REQUIRE_SINGLE_FAMILY_MESSAGE = "Scan or Get operations using SingleColumnValueExcludeFilter must have a single family specified with #addFamily().";
    private static final FilterSupportStatus UNSUPPORTED_STATUS = FilterSupportStatus.newNotSupported("Scan or Get operations using SingleColumnValueExcludeFilter must have a single family specified with #addFamily().");
    private final SingleColumnValueFilterAdapter delegateAdapter;

    public SingleColumnValueExcludeFilterAdapter(SingleColumnValueFilterAdapter delegateAdapter) {
        this.delegateAdapter = delegateAdapter;
    }

    @Override
    public RowFilter adapt(FilterAdapterContext context, SingleColumnValueExcludeFilter filter) throws IOException {
        String family = Bytes.toString((byte[])context.getScan().getFamilies()[0]);
        ByteString qualifier = ByteString.copyFrom((byte[])filter.getQualifier());
        return Filters.FILTERS.chain().filter(this.delegateAdapter.toFilter(context, (SingleColumnValueFilter)filter)).filter((Filters.Filter)Filters.FILTERS.interleave().filter((Filters.Filter)SingleColumnValueExcludeFilterAdapter.range(family).endOpen((Object)qualifier)).filter((Filters.Filter)SingleColumnValueExcludeFilterAdapter.range(family).startOpen((Object)qualifier))).toProto();
    }

    private static Filters.QualifierRangeFilter range(String family) {
        return Filters.FILTERS.qualifier().rangeWithinFamily(family);
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, SingleColumnValueExcludeFilter filter) {
        FilterSupportStatus delegateStatus = this.delegateAdapter.isFilterSupported(context, (SingleColumnValueFilter)filter);
        if (!delegateStatus.isSupported()) {
            return delegateStatus;
        }
        if (context.getScan().numFamilies() != 1) {
            return UNSUPPORTED_STATUS;
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

