/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.data.v2.wrappers.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.filters.ValueFilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.util.ByteStringer;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class SingleColumnValueFilterAdapter
extends TypedFilterAdapterBase<SingleColumnValueFilter> {
    @VisibleForTesting
    static final Filters.Filter LATEST_ONLY_FILTER = Filters.FILTERS.limit().cellsPerColumn(1);
    private final ValueFilterAdapter delegateAdapter;

    public SingleColumnValueFilterAdapter(ValueFilterAdapter delegateAdapter) {
        this.delegateAdapter = delegateAdapter;
    }

    @Override
    public RowFilter adapt(FilterAdapterContext context, SingleColumnValueFilter filter) throws IOException {
        return this.toFilter(context, filter).toProto();
    }

    Filters.Filter toFilter(FilterAdapterContext context, SingleColumnValueFilter filter) throws IOException {
        Filters.ChainFilter columnSpecFilter = SingleColumnValueFilterAdapter.getColumnSpecFilter(filter.getFamily(), filter.getQualifier(), filter.getLatestVersionOnly());
        if (filter.getFilterIfMissing()) {
            return Filters.FILTERS.condition(this.addValue(context, filter, columnSpecFilter)).then(Filters.FILTERS.pass());
        }
        return Filters.FILTERS.interleave().filter((Filters.Filter)Filters.FILTERS.condition(this.addValue(context, filter, columnSpecFilter.clone())).then(Filters.FILTERS.pass())).filter((Filters.Filter)Filters.FILTERS.condition((Filters.Filter)columnSpecFilter).otherwise(Filters.FILTERS.pass()));
    }

    private Filters.Filter addValue(FilterAdapterContext context, SingleColumnValueFilter filter, Filters.ChainFilter columnSpecFilter) throws IOException {
        return columnSpecFilter.clone().filter(this.createValueMatchFilter(context, filter));
    }

    @VisibleForTesting
    static Filters.ChainFilter getColumnSpecFilter(byte[] family, byte[] qualifier, boolean latestVersionOnly) throws IOException {
        ByteString wrappedQual = ByteStringer.wrap((byte[])ReaderExpressionHelper.quoteRegularExpression(qualifier));
        String wrappedFamily = Bytes.toString((byte[])ReaderExpressionHelper.quoteRegularExpression(family));
        Filters.ChainFilter builder = Filters.FILTERS.chain().filter(Filters.FILTERS.family().regex(wrappedFamily)).filter(Filters.FILTERS.qualifier().regex(wrappedQual));
        if (latestVersionOnly) {
            builder.filter(LATEST_ONLY_FILTER);
        }
        return builder;
    }

    private Filters.Filter createValueMatchFilter(FilterAdapterContext context, SingleColumnValueFilter filter) throws IOException {
        ValueFilter valueFilter = new ValueFilter(filter.getOperator(), filter.getComparator());
        return this.delegateAdapter.toFilter(context, valueFilter);
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, SingleColumnValueFilter filter) {
        return this.delegateAdapter.isFilterSupported(context, new ValueFilter(filter.getOperator(), filter.getComparator()));
    }
}

