/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.UnsupportedStatusCollector;
import com.google.cloud.bigtable.util.RowKeyWrapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.RangeSet;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.filter.Filter;

public class SingleFilterAdapter<T extends Filter> {
    private final Class<T> filterClass;
    private final TypedFilterAdapter<T> adapter;
    private final UnsupportedStatusCollector<T> unsupportedStatusCollector;

    public SingleFilterAdapter(Class<T> filterClass, TypedFilterAdapter<T> adapter) {
        this(filterClass, adapter, new SingleFilterStatusCollector<T>(adapter));
    }

    public SingleFilterAdapter(Class<T> filterClass, TypedFilterAdapter<T> adapter, UnsupportedStatusCollector<T> unsupportedStatusCollector) {
        this.filterClass = filterClass;
        this.adapter = adapter;
        this.unsupportedStatusCollector = unsupportedStatusCollector;
    }

    public RowFilter adapt(FilterAdapterContext context, Filter hbaseFilter) throws IOException {
        T typedFilter = this.getTypedFilter(hbaseFilter);
        return this.adapter.adapt(context, typedFilter);
    }

    public FilterSupportStatus isSupported(FilterAdapterContext context, Filter hbaseFilter) {
        Preconditions.checkArgument((boolean)this.isFilterAProperSublcass(hbaseFilter));
        return this.adapter.isFilterSupported(context, this.getTypedFilter(hbaseFilter));
    }

    public void collectUnsupportedStatuses(FilterAdapterContext context, Filter filter, List<FilterSupportStatus> statuses) {
        Preconditions.checkArgument((boolean)this.isFilterAProperSublcass(filter));
        this.unsupportedStatusCollector.collectUnsupportedStatuses(context, this.unchecked(filter), statuses);
    }

    public RangeSet<RowKeyWrapper> getIndexScanHint(Filter filter) {
        return this.adapter.getIndexScanHint(this.unchecked(filter));
    }

    T unchecked(Filter filter) {
        return (T)filter;
    }

    protected T getTypedFilter(Filter filter) {
        if (this.isFilterAProperSublcass(filter)) {
            return this.unchecked(filter);
        }
        throw new IllegalStateException(String.format("FilterAdapter %s cannot operate on a filter of type %s", this.getClass().getCanonicalName(), filter.getClass().getCanonicalName()));
    }

    protected boolean isFilterAProperSublcass(Filter filter) {
        return this.filterClass.isAssignableFrom(filter.getClass());
    }

    private static class SingleFilterStatusCollector<T extends Filter>
    implements UnsupportedStatusCollector<T> {
        private final TypedFilterAdapter<T> adapter;

        public SingleFilterStatusCollector(TypedFilterAdapter<T> adapter) {
            this.adapter = adapter;
        }

        @Override
        public void collectUnsupportedStatuses(FilterAdapterContext context, T filter, List<FilterSupportStatus> unsupportedStatuses) {
            FilterSupportStatus status = this.adapter.isFilterSupported(context, filter);
            if (!status.isSupported()) {
                unsupportedStatuses.add(status);
            }
        }
    }
}

