/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.cloud.bigtable.data.v2.wrappers.Filters;
import com.google.cloud.bigtable.hbase.BigtableConstants;

public class TimestampFilterUtil {
    public static long hbaseToBigtableTimeUnit(long timestamp) {
        return BigtableConstants.BIGTABLE_TIMEUNIT.convert(timestamp, BigtableConstants.HBASE_TIMEUNIT);
    }

    public static Filters.Filter hbaseToTimestampRangeFilter(long hbaseStartTimestamp, long hbaseEndTimestamp) {
        return TimestampFilterUtil.toTimestampRangeFilter(TimestampFilterUtil.hbaseToBigtableTimeUnit(hbaseStartTimestamp), TimestampFilterUtil.hbaseToBigtableTimeUnit(hbaseEndTimestamp));
    }

    public static Filters.Filter toTimestampRangeFilter(long bigtableStartTimestamp, long bigtableEndTimestamp) {
        return (Filters.Filter)Filters.FILTERS.timestamp().range().of((Object)bigtableStartTimestamp, (Object)bigtableEndTimestamp);
    }
}

