/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.cloud.bigtable.hbase.adapters.ResponseAdapter;
import com.google.common.base.Throwables;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.io.IOException;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;

public class BigtableResultScannerAdapter<T> {
    final ResponseAdapter<T, Result> rowAdapter;

    public BigtableResultScannerAdapter(ResponseAdapter<T, Result> rowAdapter) {
        this.rowAdapter = rowAdapter;
    }

    public ResultScanner adapt(final com.google.cloud.bigtable.grpc.scanner.ResultScanner<T> bigtableResultScanner, final Span span) {
        return new AbstractClientScanner(){
            int rowCount = 0;

            public Result next() throws IOException {
                Object row = bigtableResultScanner.next();
                if (row == null) {
                    this.closeSpan();
                    return null;
                }
                ++this.rowCount;
                return BigtableResultScannerAdapter.this.rowAdapter.adaptResponse(row);
            }

            public void close() {
                try {
                    bigtableResultScanner.close();
                }
                catch (IOException ioe) {
                    throw Throwables.propagate((Throwable)ioe);
                }
                finally {
                    this.closeSpan();
                }
            }

            protected void closeSpan() {
                try (Scope c = Tracing.getTracer().withSpan(span);){
                    span.end();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public boolean renewLease() {
                throw new UnsupportedOperationException("renewLease");
            }
        };
    }
}

