/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadOperationAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.ScanAdapter;
import com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;

public class GetAdapter
implements ReadOperationAdapter<Get> {
    protected final ScanAdapter scanAdapter;

    public static Get setCheckExistenceOnly(Get get) {
        if (get.isCheckExistenceOnly()) {
            return get;
        }
        Get existsGet = new Get(get);
        existsGet.setCheckExistenceOnly(true);
        return existsGet;
    }

    public GetAdapter(ScanAdapter scanAdapter) {
        this.scanAdapter = scanAdapter;
    }

    @Override
    public ReadRowsRequest.Builder adapt(Get operation, ReadHooks readHooks) {
        Scan operationAsScan = new Scan(this.addKeyOnlyFilter(operation));
        this.scanAdapter.throwIfUnsupportedScan(operationAsScan);
        return ReadRowsRequest.newBuilder().setFilter(this.scanAdapter.buildFilter(operationAsScan, readHooks)).setRows(RowSet.newBuilder().addRowKeys(ByteString.copyFrom((byte[])operation.getRow())));
    }

    private Get addKeyOnlyFilter(Get get) {
        if (get.isCheckExistenceOnly()) {
            Get existsGet = new Get(get);
            if (get.getFilter() == null) {
                existsGet.setFilter((Filter)new KeyOnlyFilter());
            } else {
                existsGet.setFilter((Filter)new FilterList(new Filter[]{get.getFilter(), new KeyOnlyFilter()}));
            }
            return existsGet;
        }
        return get;
    }
}

