/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import com.google.cloud.bigtable.hbase.adapters.ResponseAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.RowCell;
import com.google.cloud.bigtable.hbase.util.TimestampConverter;
import com.google.cloud.bigtable.util.ByteStringer;
import com.google.protobuf.ByteString;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class RowAdapter
implements ResponseAdapter<Row, Result> {
    @Override
    public Result adaptResponse(Row response) {
        if (response == null) {
            return new Result();
        }
        TreeSet<RowCell> hbaseCells = new TreeSet<RowCell>((Comparator<RowCell>)KeyValue.COMPARATOR);
        byte[] rowKey = ByteStringer.extract((ByteString)response.getKey());
        for (Family family : response.getFamiliesList()) {
            byte[] familyNameBytes = Bytes.toBytes((String)family.getName());
            for (Column column : family.getColumnsList()) {
                byte[] columnQualifier = ByteStringer.extract((ByteString)column.getQualifier());
                for (Cell cell : column.getCellsList()) {
                    if (cell.getLabelsCount() > 0) continue;
                    long hbaseTimestamp = TimestampConverter.bigtable2hbase(cell.getTimestampMicros());
                    RowCell keyValue = new RowCell(rowKey, familyNameBytes, columnQualifier, hbaseTimestamp, ByteStringer.extract((ByteString)cell.getValue()));
                    hbaseCells.add(keyValue);
                }
            }
        }
        return Result.create((org.apache.hadoop.hbase.Cell[])hbaseCells.toArray(new org.apache.hadoop.hbase.Cell[hbaseCells.size()]));
    }
}

