/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.wrappers.Filters;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadOperationAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.adapters.read.RowRangeAdapter;
import com.google.cloud.bigtable.util.ByteStringer;
import com.google.cloud.bigtable.util.RowKeyWrapper;
import com.google.common.base.Optional;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;

public class ScanAdapter
implements ReadOperationAdapter<Scan> {
    private static final int UNSET_MAX_RESULTS_PER_COLUMN_FAMILY = -1;
    private final FilterAdapter filterAdapter;
    private final RowRangeAdapter rowRangeAdapter;

    public ScanAdapter(FilterAdapter filterAdapter, RowRangeAdapter rowRangeAdapter) {
        this.filterAdapter = filterAdapter;
        this.rowRangeAdapter = rowRangeAdapter;
    }

    public void throwIfUnsupportedScan(Scan scan) {
        if (scan.getFilter() != null) {
            this.filterAdapter.throwIfUnsupportedFilter(scan, scan.getFilter());
        }
        if (scan.getMaxResultsPerColumnFamily() != -1) {
            throw new UnsupportedOperationException("Limiting of max results per column family is not supported.");
        }
    }

    public RowFilter buildFilter(Scan scan, ReadHooks hooks) {
        Optional<RowFilter> userFilter;
        Filters.ChainFilter chain = Filters.FILTERS.chain();
        Optional<Filters.Filter> familyFilter = this.createColumnFamilyFilter(scan);
        if (familyFilter.isPresent()) {
            chain.filter((Filters.Filter)familyFilter.get());
        }
        if (scan.getTimeRange() != null && !scan.getTimeRange().isAllTime()) {
            chain.filter(this.createTimeRangeFilter(scan.getTimeRange()));
        }
        if (scan.getMaxVersions() != Integer.MAX_VALUE) {
            chain.filter(this.createColumnLimitFilter(scan.getMaxVersions()));
        }
        if ((userFilter = this.createUserFilter(scan, hooks)).isPresent()) {
            chain.filter(Filters.FILTERS.fromProto((RowFilter)userFilter.get()));
        }
        return chain.toProto();
    }

    @Override
    public ReadRowsRequest.Builder adapt(Scan scan, ReadHooks readHooks) {
        this.throwIfUnsupportedScan(scan);
        RowSet rowSet = this.getRowSet(scan);
        rowSet = this.narrowRowSet(rowSet, scan.getFilter());
        return ReadRowsRequest.newBuilder().setRows(rowSet).setFilter(this.buildFilter(scan, readHooks));
    }

    private RowSet getRowSet(Scan scan) {
        if (scan instanceof BigtableExtendedScan) {
            return ((BigtableExtendedScan)scan).getRowSet();
        }
        RowSet.Builder rowSetBuilder = RowSet.newBuilder();
        ByteString startRow = ByteString.copyFrom((byte[])scan.getStartRow());
        if (scan.isGetScan()) {
            rowSetBuilder.addRowKeys(startRow);
        } else {
            ByteString stopRow;
            RowRange.Builder range = RowRange.newBuilder();
            if (!startRow.isEmpty()) {
                range.setStartKeyClosed(startRow);
            }
            if (!(stopRow = ByteString.copyFrom((byte[])scan.getStopRow())).isEmpty()) {
                range.setEndKeyOpen(stopRow);
            }
            rowSetBuilder.addRowRanges(range);
        }
        return rowSetBuilder.build();
    }

    private static byte[] quoteRegex(byte[] unquoted) {
        try {
            return ReaderExpressionHelper.quoteRegularExpression(unquoted);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when writing to ByteArrayOutputStream", e);
        }
    }

    private Optional<RowFilter> createUserFilter(Scan scan, ReadHooks hooks) {
        if (scan.getFilter() == null) {
            return Optional.absent();
        }
        try {
            return this.filterAdapter.adaptFilter(new FilterAdapterContext(scan, hooks), scan.getFilter());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to adapt filter", ioe);
        }
    }

    private RowSet narrowRowSet(RowSet rowSet, Filter filter) {
        if (filter == null) {
            return rowSet;
        }
        RangeSet<RowKeyWrapper> filterRangeSet = this.filterAdapter.getIndexScanHint(filter);
        if (filterRangeSet.encloses(Range.all())) {
            return rowSet;
        }
        RangeSet<RowKeyWrapper> scanRangeSet = this.rowRangeAdapter.rowSetToRangeSet(rowSet);
        scanRangeSet.removeAll(filterRangeSet.complement());
        return this.rowRangeAdapter.rangeSetToRowSet(scanRangeSet);
    }

    private Filters.Filter createColumnQualifierFilter(byte[] unquotedQualifier) {
        return Filters.FILTERS.qualifier().regex(ByteStringer.wrap((byte[])ScanAdapter.quoteRegex(unquotedQualifier)));
    }

    private Filters.Filter createFamilyFilter(byte[] familyName) {
        return Filters.FILTERS.family().exactMatch(new String(familyName));
    }

    private Filters.Filter createColumnLimitFilter(int maxVersionsPerColumn) {
        return Filters.FILTERS.limit().cellsPerColumn(maxVersionsPerColumn);
    }

    private Filters.Filter createTimeRangeFilter(TimeRange timeRange) {
        Filters.TimestampRangeFilter rangeBuilder = Filters.FILTERS.timestamp().range();
        rangeBuilder.startClosed((Object)this.convertUnits(timeRange.getMin()));
        if (timeRange.getMax() != Long.MAX_VALUE) {
            rangeBuilder.endOpen((Object)this.convertUnits(timeRange.getMax()));
        }
        return rangeBuilder;
    }

    private long convertUnits(long hbaseUnits) {
        return BigtableConstants.BIGTABLE_TIMEUNIT.convert(hbaseUnits, BigtableConstants.HBASE_TIMEUNIT);
    }

    private Optional<Filters.Filter> createColumnFamilyFilter(Scan scan) {
        if (!scan.hasFamilies()) {
            return Optional.absent();
        }
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        Map familyMap = scan.getFamilyMap();
        for (Map.Entry entry : familyMap.entrySet()) {
            Filters.Filter familyFilter = this.createFamilyFilter((byte[])entry.getKey());
            NavigableSet qualifiers = (NavigableSet)entry.getValue();
            if (qualifiers != null) {
                Filters.InterleaveFilter columnFilters = Filters.FILTERS.interleave();
                for (byte[] qualifier : qualifiers) {
                    columnFilters.filter(this.createColumnQualifierFilter(qualifier));
                }
                interleave.filter((Filters.Filter)Filters.FILTERS.chain().filter(familyFilter).filter((Filters.Filter)columnFilters));
                continue;
            }
            interleave.filter(familyFilter);
        }
        return Optional.of((Object)interleave);
    }
}

