/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

public class TimestampRangeFilter
extends FilterBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long startTimestampInclusive;
    private final long endTimestampExclusive;

    public TimestampRangeFilter(long startTimestamp, long endTimestamp) {
        this.startTimestampInclusive = startTimestamp;
        this.endTimestampExclusive = endTimestamp;
    }

    public long getStartTimestampInclusive() {
        return this.startTimestampInclusive;
    }

    public long getEndTimestampExclusive() {
        return this.endTimestampExclusive;
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        long timestamp = cell.getTimestamp();
        if (this.startTimestampInclusive <= timestamp && timestamp < this.endTimestampExclusive) {
            return Filter.ReturnCode.INCLUDE;
        }
        return Filter.ReturnCode.SKIP;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TimestampRangeFilter)) {
            return false;
        }
        TimestampRangeFilter other = (TimestampRangeFilter)obj;
        return this.startTimestampInclusive == other.startTimestampInclusive && this.endTimestampExclusive == other.endTimestampExclusive;
    }

    public byte[] toByteArray() throws IOException {
        Throwable throwable = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            ObjectOutputStream out = new ObjectOutputStream(bos);
            Throwable throwable2 = null;
            try {
                out.writeObject(this);
                out.flush();
                byArray = bos.toByteArray();
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        TimestampRangeFilter.$closeResource(throwable2, out);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            TimestampRangeFilter.$closeResource(throwable2, out);
            return byArray;
        }
    }

    public static TimestampRangeFilter parseFrom(byte[] bytes) throws DeserializationException {
        TimestampRangeFilter timestampRangeFilter;
        ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Throwable throwable = null;
        try {
            timestampRangeFilter = (TimestampRangeFilter)is.readObject();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    TimestampRangeFilter.$closeResource(throwable, is);
                    throw throwable3;
                }
            }
            catch (Exception e) {
                throw new DeserializationException((Throwable)e);
            }
        }
        TimestampRangeFilter.$closeResource(throwable, is);
        return timestampRangeFilter;
    }
}

