/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.util;

import com.google.cloud.bigtable.hbase.BigtableConstants;

public class TimestampConverter {
    private static final long STEP = BigtableConstants.BIGTABLE_TIMEUNIT.convert(1L, BigtableConstants.HBASE_TIMEUNIT);
    private static final long BIGTABLE_MAX_TIMESTAMP = Long.MAX_VALUE - Long.MAX_VALUE % STEP;
    private static final long HBASE_EFFECTIVE_MAX_TIMESTAMP = BigtableConstants.HBASE_TIMEUNIT.convert(BIGTABLE_MAX_TIMESTAMP, BigtableConstants.BIGTABLE_TIMEUNIT);

    public static long hbase2bigtable(long timestamp) {
        if (timestamp < HBASE_EFFECTIVE_MAX_TIMESTAMP) {
            return BigtableConstants.BIGTABLE_TIMEUNIT.convert(timestamp, BigtableConstants.HBASE_TIMEUNIT);
        }
        return BIGTABLE_MAX_TIMESTAMP;
    }

    public static long bigtable2hbase(long timestamp) {
        if (timestamp >= BIGTABLE_MAX_TIMESTAMP) {
            return Long.MAX_VALUE;
        }
        return BigtableConstants.HBASE_TIMEUNIT.convert(timestamp, BigtableConstants.BIGTABLE_TIMEUNIT);
    }
}

