/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.cloud.bigtable.hbase.adapters.admin.ColumnDescriptorAdapter;
import com.google.cloud.bigtable.hbase.adapters.admin.TableAdapter;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.longrunning.Operation;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import io.grpc.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public abstract class AbstractBigtableAdmin
implements Admin {
    protected final Logger LOG = new Logger(this.getClass());
    private final Set<TableName> disabledTables;
    private final Configuration configuration;
    private final BigtableOptions options;
    private final AbstractBigtableConnection connection;
    protected final BigtableTableAdminClient bigtableTableAdminClient;
    private BigtableInstanceName bigtableInstanceName;
    private BigtableClusterName bigtableSnapshotClusterName;
    private final ColumnDescriptorAdapter columnDescriptorAdapter = new ColumnDescriptorAdapter();
    private final TableAdapter tableAdapter;

    public AbstractBigtableAdmin(AbstractBigtableConnection connection) throws IOException {
        this.LOG.debug("Creating BigtableAdmin", new Object[0]);
        this.configuration = connection.getConfiguration();
        this.options = connection.getOptions();
        this.connection = connection;
        this.bigtableTableAdminClient = connection.getSession().getTableAdminClient();
        this.disabledTables = connection.getDisabledTables();
        this.bigtableInstanceName = this.options.getInstanceName();
        this.tableAdapter = new TableAdapter(this.bigtableInstanceName, this.columnDescriptorAdapter);
        String clusterId = this.configuration.get("google.bigtable.snapshot.cluster.id", null);
        if (clusterId != null) {
            this.bigtableSnapshotClusterName = this.bigtableInstanceName.toClusterName(clusterId);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean tableExists(TableName tableName) throws IOException {
        for (TableName existingTableName : this.listTableNames(tableName.getNameAsString())) {
            if (!existingTableName.equals((Object)tableName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean tableExists(String tableName) throws IOException {
        return this.tableExists(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.getTableDescriptors(this.listTableNames());
    }

    private HTableDescriptor[] getTableDescriptors(TableName[] tableNames) throws IOException {
        HTableDescriptor[] response = new HTableDescriptor[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            response[i] = this.getTableDescriptor(tableNames[i]);
        }
        return response;
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.getTableDescriptors(this.listTableNames(pattern));
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables(pattern);
    }

    @Deprecated
    public TableName[] listTableNames(String patternStr) throws IOException {
        return this.listTableNames(Pattern.compile(patternStr));
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        ArrayList<TableName> result = new ArrayList<TableName>();
        for (TableName tableName : this.listTableNames()) {
            if (!pattern.matcher(tableName.getNameAsString()).matches()) continue;
            result.add(tableName);
        }
        return result.toArray(new TableName[result.size()]);
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames(pattern);
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames(regex);
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables(regex);
    }

    public TableName[] listTableNames() throws IOException {
        return this.asTableNames(this.requestTableList().getTablesList());
    }

    private ListTablesResponse requestTableList() throws IOException {
        try {
            ListTablesRequest.Builder builder = ListTablesRequest.newBuilder();
            builder.setParent(this.bigtableInstanceName.toString());
            return this.bigtableTableAdminClient.listTables(builder.build());
        }
        catch (Throwable throwable) {
            throw new IOException("Failed to listTables", throwable);
        }
    }

    private TableName[] asTableNames(List<Table> tablesList) {
        TableName[] result = new TableName[tablesList.size()];
        for (int i = 0; i < tablesList.size(); ++i) {
            String bigtableFullTableName = tablesList.get(i).getName();
            String name = this.bigtableInstanceName.toTableId(bigtableFullTableName);
            result[i] = TableName.valueOf((String)name);
        }
        return result;
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws IOException {
        if (tableName == null) {
            return null;
        }
        String bigtableTableName = this.toBigtableName(tableName);
        GetTableRequest request = GetTableRequest.newBuilder().setName(bigtableTableName).build();
        try {
            return this.tableAdapter.adapt(this.bigtableTableAdminClient.getTable(request));
        }
        catch (Throwable throwable) {
            if (Status.fromThrowable((Throwable)throwable).getCode() == Status.Code.NOT_FOUND) {
                throw new TableNotFoundException(tableName);
            }
            throw new IOException("Failed to getTableDescriptor() on " + tableName, throwable);
        }
    }

    @Deprecated
    public String[] getTableNames(String regex) throws IOException {
        HTableDescriptor[] tableDescriptors = this.listTables(regex);
        String[] tableNames = new String[tableDescriptors.length];
        for (int i = 0; i < tableDescriptors.length; ++i) {
            tableNames[i] = tableDescriptors[i].getNameAsString();
        }
        return tableNames;
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.createTable(desc, AbstractBigtableAdmin.createSplitKeys(startKey, endKey, numRegions));
    }

    public static byte[][] createSplitKeys(byte[] startKey, byte[] endKey, int numRegions) {
        Object splitKeys;
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            splitKeys = new byte[][]{startKey, endKey};
        } else {
            splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
            if (splitKeys == null || ((byte[][])splitKeys).length != numRegions - 1) {
                throw new IllegalArgumentException("Unable to split key range into enough regions");
            }
        }
        return splitKeys;
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.createTable(desc.getTableName(), this.tableAdapter.adapt(desc, splitKeys));
    }

    protected void createTable(TableName tableName, CreateTableRequest.Builder builder) throws IOException {
        builder.setParent(this.bigtableInstanceName.toString());
        try {
            this.bigtableTableAdminClient.createTable(builder.build());
        }
        catch (Throwable throwable) {
            throw AbstractBigtableAdmin.convertToTableExistsException(tableName, throwable);
        }
    }

    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.LOG.warn("Creating the table synchronously", new Object[0]);
        CreateTableRequest.Builder builder = this.tableAdapter.adapt(desc, splitKeys);
        this.createTableAsync(builder, desc.getTableName());
    }

    protected ListenableFuture<Table> createTableAsync(CreateTableRequest.Builder builder, final TableName tableName) throws IOException {
        builder.setParent(this.bigtableInstanceName.toString());
        ListenableFuture future = this.bigtableTableAdminClient.createTableAsync(builder.build());
        final SettableFuture settableFuture = SettableFuture.create();
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Table>(){

            public void onSuccess(@Nullable Table result) {
                settableFuture.set((Object)result);
            }

            public void onFailure(Throwable t) {
                settableFuture.setException((Throwable)AbstractBigtableAdmin.convertToTableExistsException(tableName, t));
            }
        });
        return settableFuture;
    }

    public static IOException convertToTableExistsException(TableName tableName, Throwable throwable) {
        if (Status.fromThrowable((Throwable)throwable).getCode() == Status.Code.ALREADY_EXISTS) {
            return new TableExistsException(tableName);
        }
        return new IOException(String.format("Failed to create table '%s'", tableName), throwable);
    }

    public void deleteTable(TableName tableName) throws IOException {
        DeleteTableRequest.Builder deleteBuilder = DeleteTableRequest.newBuilder();
        deleteBuilder.setName(this.toBigtableName(tableName));
        try {
            this.bigtableTableAdminClient.deleteTable(deleteBuilder.build());
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to delete table '%s'", tableName.getNameAsString()), throwable);
        }
        this.disabledTables.remove(tableName);
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            try {
                this.deleteTable(table.getTableName());
            }
            catch (IOException ex) {
                this.LOG.info("Failed to delete table " + table.getTableName(), (Throwable)ex, new Object[0]);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void enableTable(TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
        this.disabledTables.remove(tableName);
        this.LOG.warn("Table " + tableName + " was enabled in memory only.", new Object[0]);
    }

    @Deprecated
    public void enableTable(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(regex)) {
            this.enableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(pattern)) {
            this.enableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public void disableTable(TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
        if (this.isTableDisabled(tableName)) {
            throw new TableNotEnabledException(tableName);
        }
        this.disabledTables.add(tableName);
        this.LOG.warn("Table " + tableName + " was disabled in memory only.", new Object[0]);
    }

    @Deprecated
    public void disableTable(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(regex)) {
            this.disableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(pattern)) {
            this.disableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return !this.isTableDisabled(tableName);
    }

    @Deprecated
    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.disabledTables.contains(tableName);
    }

    @Deprecated
    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.tableExists(tableName);
    }

    public void addColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        String columnName = column.getNameAsString();
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(columnName).setCreate(this.columnDescriptorAdapter.adapt(column).build());
        this.modifyColumn(tableName, columnName, "add", modification);
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        String columnName = column.getNameAsString();
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(columnName).setUpdate(this.columnDescriptorAdapter.adapt(column).build());
        this.modifyColumn(tableName, columnName, "update", modification);
    }

    public void deleteColumn(TableName tableName, byte[] columnName) throws IOException {
        String columnNameStr = Bytes.toString((byte[])columnName);
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(columnNameStr).setDrop(true);
        this.modifyColumn(tableName, columnNameStr, "delete", modification);
    }

    protected void modifyColumn(TableName tableName, String columnName, String modificationType, ModifyColumnFamiliesRequest.Modification.Builder modification) throws IOException {
        ModifyColumnFamiliesRequest.Builder modifyColumnBuilder = ModifyColumnFamiliesRequest.newBuilder().addModifications(modification).setName(this.toBigtableName(tableName));
        try {
            this.bigtableTableAdminClient.modifyColumnFamily(modifyColumnBuilder.build());
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to %s column '%s' in table '%s'", modificationType, columnName, tableName.getNameAsString()), throwable);
        }
    }

    @Deprecated
    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((String)tableName), column);
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((String)tableName), descriptor);
    }

    @Deprecated
    public void deleteColumn(String tableName, byte[] columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), columnName);
    }

    @Deprecated
    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), Bytes.toBytes((String)columnName));
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return new ClusterStatus(){

            public Collection<ServerName> getServers() {
                return Collections.emptyList();
            }
        };
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        ArrayList<HRegionInfo> regionInfos = new ArrayList<HRegionInfo>();
        for (HRegionLocation location : this.connection.getRegionLocator(tableName).getAllRegionLocations()) {
            regionInfos.add(location.getRegionInfo());
        }
        return regionInfos;
    }

    public void close() throws IOException {
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        TableName[] tableNameArray = tableNames.toArray(new TableName[tableNames.size()]);
        return this.getTableDescriptors(tableNameArray);
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        TableName[] tableNameArray = new TableName[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            tableNameArray[i] = TableName.valueOf((String)names.get(i));
        }
        return this.getTableDescriptors(tableNameArray);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("project", (Object)this.options.getProjectId()).add("instance", (Object)this.options.getInstanceId()).add("adminHost", (Object)this.options.getAdminHost()).toString();
    }

    public int getOperationTimeout() {
        throw new UnsupportedOperationException("getOperationTimeout");
    }

    public void abort(String why, Throwable e) {
        throw new UnsupportedOperationException("abort");
    }

    public boolean isAborted() {
        throw new UnsupportedOperationException("isAborted");
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        if (!preserveSplits) {
            this.LOG.info("truncate will preserveSplits. The passed in variable is ignored.", new Object[0]);
        }
        this.issueBulkDelete(tableName, DropRowRangeRequest.newBuilder().setDeleteAllDataFromTable(true));
        this.disabledTables.remove(tableName);
    }

    public void deleteRowRangeByPrefix(TableName tableName, byte[] prefix) throws IOException {
        this.issueBulkDelete(tableName, DropRowRangeRequest.newBuilder().setDeleteAllDataFromTable(false).setRowKeyPrefix(ByteString.copyFrom((byte[])prefix)));
    }

    private void issueBulkDelete(TableName tableName, DropRowRangeRequest.Builder deleteRequest) throws IOException {
        try {
            this.bigtableTableAdminClient.dropRowRange(deleteRequest.setName(this.toBigtableName(tableName)).build());
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to truncate table '%s'", tableName.getNameAsString()), throwable);
        }
    }

    protected String toBigtableName(TableName tableName) {
        return this.bigtableInstanceName.toTableNameStr(tableName.getNameAsString());
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.tableExists(tableName);
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return new Pair((Object)0, (Object)0);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf((byte[])tableName));
    }

    public Pair<Integer, Integer> getAlterStatus(String tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf((String)tableName));
    }

    public void snapshot(String snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        Operation operation = this.snapshotTable(snapshotName, tableName);
        try {
            this.connection.getSession().getInstanceAdminClient().waitForOperation(operation);
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for snapshot creation to finish", e);
        }
    }

    protected Operation snapshotTable(String snapshotName, TableName tableName) throws IOException {
        SnapshotTableRequest.Builder requestBuilder = SnapshotTableRequest.newBuilder().setCluster(this.getSnapshotClusterName().toString()).setSnapshotId(snapshotName).setName(this.options.getInstanceName().toTableNameStr(tableName.getNameAsString()));
        int ttlSecs = this.configuration.getInt("google.bigtable.snapshot.default.ttl.secs", -1);
        if (ttlSecs > 0) {
            requestBuilder.setTtl(Duration.newBuilder().setSeconds((long)ttlSecs).build());
        }
        ListenableFuture future = this.bigtableTableAdminClient.snapshotTableAsync(requestBuilder.build());
        return (Operation)Futures.getChecked((Future)future, IOException.class);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf((byte[])tableName));
    }

    public void snapshot(byte[] snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString((byte[])snapshotName), tableName);
    }

    public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.cloneSnapshot(snapshotName, TableName.valueOf((byte[])tableName));
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.cloneSnapshot(Bytes.toString((byte[])snapshotName), tableName);
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        CreateTableFromSnapshotRequest request = CreateTableFromSnapshotRequest.newBuilder().setParent(this.options.getInstanceName().toString()).setTableId(tableName.getNameAsString()).setSourceSnapshot(this.getClusterName().toSnapshotName(snapshotName)).build();
        Operation operation = (Operation)Futures.getChecked((Future)this.bigtableTableAdminClient.createTableFromSnapshotAsync(request), IOException.class);
        try {
            this.connection.getSession().getInstanceAdminClient().waitForOperation(operation);
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for cloneSnapshot operation to finish", e);
        }
    }

    protected BigtableClusterName getClusterName() throws IOException {
        return this.connection.getSession().getClusterName();
    }

    protected BigtableClusterName getSnapshotClusterName() throws IOException {
        if (this.bigtableSnapshotClusterName == null) {
            try {
                this.bigtableSnapshotClusterName = this.getClusterName();
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Failed to determine which cluster to use for snapshots, please configure it using google.bigtable.snapshot.cluster.id");
            }
        }
        return this.bigtableSnapshotClusterName;
    }

    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        this.deleteSnapshot(Bytes.toString((byte[])snapshotName));
    }

    public void deleteSnapshot(String snapshotName) throws IOException {
        String btSnapshotName = this.getClusterName().toSnapshotName(snapshotName);
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setName(btSnapshotName).build();
        Futures.getUnchecked((Future)this.bigtableTableAdminClient.deleteSnapshotAsync(request));
    }

    public void deleteSnapshots(String regex) throws IOException {
        this.deleteSnapshots(Pattern.compile(regex));
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        for (HBaseProtos.SnapshotDescription snapshotDescription : this.listSnapshots(pattern)) {
            this.deleteSnapshot(snapshotDescription.getName());
        }
    }

    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) throws IOException {
        this.deleteTableSnapshots(Pattern.compile(tableNameRegex), Pattern.compile(snapshotNameRegex));
    }

    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        for (HBaseProtos.SnapshotDescription snapshotDescription : this.listTableSnapshots(tableNamePattern, snapshotNamePattern)) {
            this.deleteSnapshot(snapshotDescription.getName());
        }
    }

    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegion");
    }

    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegion");
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegionWithEncodedRegionName");
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        throw new UnsupportedOperationException("closeRegion");
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        throw new UnsupportedOperationException("getOnlineRegions");
    }

    public void flush(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("flush");
    }

    public void flushRegion(byte[] bytes) throws IOException {
        this.LOG.info("flushRegion is a no-op", new Object[0]);
    }

    public void compact(TableName tableName) throws IOException {
        this.LOG.info("compact is a no-op", new Object[0]);
    }

    public void compactRegion(byte[] bytes) throws IOException {
        this.LOG.info("compactRegion is a no-op", new Object[0]);
    }

    public void compact(TableName tableName, byte[] bytes) throws IOException {
        this.LOG.info("compact is a no-op", new Object[0]);
    }

    public void compactRegion(byte[] bytes, byte[] bytes2) throws IOException {
        this.LOG.info("compactRegion is a no-op", new Object[0]);
    }

    public void majorCompact(TableName tableName) throws IOException {
        this.LOG.info("majorCompact is a no-op", new Object[0]);
    }

    public void majorCompactRegion(byte[] bytes) throws IOException {
        this.LOG.info("majorCompactRegion is a no-op", new Object[0]);
    }

    public void majorCompact(TableName tableName, byte[] bytes) throws IOException {
        this.LOG.info("majorCompact is a no-op", new Object[0]);
    }

    public void majorCompactRegion(byte[] bytes, byte[] bytes2) throws IOException {
        this.LOG.info("majorCompactRegion is a no-op", new Object[0]);
    }

    public void compactRegionServer(ServerName serverName, boolean b) throws IOException {
        this.LOG.info("compactRegionServer is a no-op", new Object[0]);
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws HBaseIOException, MasterNotRunningException, ZooKeeperConnectionException {
        this.LOG.info("move is a no-op", new Object[0]);
    }

    public void assign(byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.LOG.info("assign is a no-op", new Object[0]);
    }

    public void unassign(byte[] regionName, boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.LOG.info("unassign is a no-op", new Object[0]);
    }

    public void offline(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("offline");
    }

    public boolean setBalancerRunning(boolean on, boolean synchronous) throws MasterNotRunningException, ZooKeeperConnectionException {
        throw new UnsupportedOperationException("setBalancerRunning");
    }

    public boolean balancer() throws MasterNotRunningException, ZooKeeperConnectionException {
        throw new UnsupportedOperationException("balancer");
    }

    public boolean enableCatalogJanitor(boolean enable) throws MasterNotRunningException {
        throw new UnsupportedOperationException("enableCatalogJanitor");
    }

    public int runCatalogScan() throws MasterNotRunningException {
        throw new UnsupportedOperationException("runCatalogScan");
    }

    public boolean isCatalogJanitorEnabled() throws MasterNotRunningException {
        throw new UnsupportedOperationException("isCatalogJanitorEnabled");
    }

    public void mergeRegions(byte[] encodedNameOfRegionA, byte[] encodedNameOfRegionB, boolean forcible) throws IOException {
        this.LOG.info("mergeRegions is a no-op", new Object[0]);
    }

    public void split(TableName tableName) throws IOException {
        this.LOG.info("split is a no-op", new Object[0]);
    }

    public void splitRegion(byte[] bytes) throws IOException {
        this.LOG.info("splitRegion is a no-op", new Object[0]);
    }

    public void split(TableName tableName, byte[] bytes) throws IOException {
        this.LOG.info("split is a no-op", new Object[0]);
    }

    public void splitRegion(byte[] bytes, byte[] bytes2) throws IOException {
        this.LOG.info("split is a no-op", new Object[0]);
    }

    public void modifyTable(TableName tableName, HTableDescriptor htd) throws IOException {
        throw new UnsupportedOperationException("modifyTable");
    }

    public void shutdown() throws IOException {
        throw new UnsupportedOperationException("shutdown");
    }

    public void stopMaster() throws IOException {
        throw new UnsupportedOperationException("stopMaster");
    }

    public void stopRegionServer(String hostnamePort) throws IOException {
        throw new UnsupportedOperationException("stopRegionServer");
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        if (!this.provideWarningsForNamespaces()) {
            throw new UnsupportedOperationException("createNamespace");
        }
        this.LOG.warn("createNamespace is a no-op", new Object[0]);
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        if (!this.provideWarningsForNamespaces()) {
            throw new UnsupportedOperationException("modifyNamespace");
        }
        this.LOG.warn("modifyNamespace is a no-op", new Object[0]);
    }

    public void deleteNamespace(String name) throws IOException {
        if (!this.provideWarningsForNamespaces()) {
            throw new UnsupportedOperationException("deleteNamespace");
        }
        this.LOG.warn("deleteNamespace is a no-op", new Object[0]);
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws IOException {
        if (this.provideWarningsForNamespaces()) {
            this.LOG.warn("getNamespaceDescriptor is a no-op", new Object[0]);
            return null;
        }
        throw new UnsupportedOperationException("getNamespaceDescriptor");
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        if (this.provideWarningsForNamespaces()) {
            this.LOG.warn("listNamespaceDescriptors is a no-op", new Object[0]);
            return new NamespaceDescriptor[0];
        }
        throw new UnsupportedOperationException("listNamespaceDescriptors");
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        if (this.provideWarningsForNamespaces()) {
            this.LOG.warn("listTableDescriptorsByNamespace is a no-op", new Object[0]);
            return new HTableDescriptor[0];
        }
        throw new UnsupportedOperationException("listTableDescriptorsByNamespace");
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        if (this.provideWarningsForNamespaces()) {
            this.LOG.warn("listTableNamesByNamespace is a no-op", new Object[0]);
            return new TableName[0];
        }
        throw new UnsupportedOperationException("listTableNamesByNamespace");
    }

    private boolean provideWarningsForNamespaces() {
        return this.configuration.getBoolean("google.bigtable.namespace.warnings", false);
    }

    public String[] getMasterCoprocessors() {
        throw new UnsupportedOperationException("getMasterCoprocessors");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedure");
    }

    public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedureWithRet");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("isProcedureFinished");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        throw new UnsupportedOperationException("coprocessorService");
    }

    public void updateConfiguration(ServerName serverName) throws IOException {
        throw new UnsupportedOperationException("updateConfiguration");
    }

    public void updateConfiguration() throws IOException {
        throw new UnsupportedOperationException("updateConfiguration");
    }

    public int getMasterInfoPort() throws IOException {
        throw new UnsupportedOperationException("getMasterInfoPort");
    }

    public void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        throw new UnsupportedOperationException("rollWALWriter");
    }
}

