/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import java.util.List;
import org.apache.hadoop.hbase.filter.Filter;

@InternalApi(value="For internal usage only")
public class FilterSupportStatus {
    public static final FilterSupportStatus SUPPORTED = new FilterSupportStatus(true, null);
    public static final FilterSupportStatus NOT_SUPPORTED_WRONG_TYPE = FilterSupportStatus.newNotSupported("Wrong filter type passed to adapter.");
    private final boolean isSupported;
    private final String reason;

    public static FilterSupportStatus newUnknownFilterType(Filter unknownFilterType) {
        return new FilterSupportStatus(false, String.format("Don't know how to adapt Filter class '%s'", unknownFilterType.getClass()));
    }

    public static FilterSupportStatus newNotSupported(String reason) {
        return new FilterSupportStatus(false, reason);
    }

    public static FilterSupportStatus newCompositeNotSupported(List<FilterSupportStatus> unsupportedSubfilters) {
        StringBuilder builder = new StringBuilder();
        for (FilterSupportStatus subStatus : unsupportedSubfilters) {
            builder.append(subStatus.getReason());
            builder.append("\n");
        }
        return new FilterSupportStatus(false, builder.toString());
    }

    private FilterSupportStatus(boolean isSupported, String reason) {
        this.isSupported = isSupported;
        this.reason = reason;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    String getReason() {
        return this.reason;
    }

    public String toString() {
        return String.format("FilterSupportStatus{isSupported=%s, reason='%s'}", this.isSupported, this.reason);
    }
}

