/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.util.Pair;

@InternalApi(value="For internal usage only")
public class FuzzyRowFilterAdapter
extends TypedFilterAdapterBase<FuzzyRowFilter> {
    private static Field FUZZY_KEY_DATA_FIELD;
    private static Exception FUZZY_KEY_DATA_FIELD_EXCEPTION;

    @Override
    public Filters.Filter adapt(FilterAdapterContext context, FuzzyRowFilter filter) throws IOException {
        List<Pair<byte[], byte[]>> pairs = FuzzyRowFilterAdapter.extractFuzzyRowFilterPairs(filter);
        if (pairs.isEmpty()) {
            return Filters.FILTERS.pass();
        }
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        for (Pair<byte[], byte[]> pair : pairs) {
            Preconditions.checkArgument((((byte[])pair.getFirst()).length == ((byte[])pair.getSecond()).length ? 1 : 0) != 0, (Object)"Fuzzy info and match mask must have the same length");
            interleave.filter(FuzzyRowFilterAdapter.createSingleRowFilter((byte[])pair.getFirst(), (byte[])pair.getSecond()));
        }
        return interleave;
    }

    private static Filters.Filter createSingleRowFilter(byte[] key, byte[] mask) throws IOException {
        ByteString.Output output = ByteString.newOutput((int)(key.length * 2));
        ReaderExpressionHelper.QuoteMetaOutputStream quotingStream = new ReaderExpressionHelper.QuoteMetaOutputStream((OutputStream)output);
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == -1) {
                quotingStream.write(key[i]);
                continue;
            }
            output.write(ReaderExpressionHelper.ANY_BYTE_BYTES);
        }
        output.write(ReaderExpressionHelper.ALL_BYTE_BYTES);
        quotingStream.close();
        return Filters.FILTERS.key().regex(output.toByteString());
    }

    static List<Pair<byte[], byte[]>> extractFuzzyRowFilterPairs(FuzzyRowFilter filter) throws IOException {
        if (FUZZY_KEY_DATA_FIELD_EXCEPTION != null) {
            throw new IOException("Could not read the contents of the FuzzyRowFilter");
        }
        try {
            return (List)FUZZY_KEY_DATA_FIELD.get(filter);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException("Could not read the contents of the FuzzyRowFilter", e);
        }
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, FuzzyRowFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }

    static {
        try {
            FUZZY_KEY_DATA_FIELD = FuzzyRowFilter.class.getDeclaredField("fuzzyKeysData");
            FUZZY_KEY_DATA_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            FUZZY_KEY_DATA_FIELD_EXCEPTION = e;
        }
    }
}

