/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class KeyOnlyFilterAdapter
extends TypedFilterAdapterBase<KeyOnlyFilter> {
    private static final Cell TEST_CELL = new KeyValue(Bytes.toBytes((int)114), Bytes.toBytes((int)102), Bytes.toBytes((int)113), 1L, Bytes.toBytes((int)118));
    private static Filters.Filter KEY_ONLY_FILTER = Filters.FILTERS.chain().filter(Filters.FILTERS.limit().cellsPerColumn(1)).filter(Filters.FILTERS.value().strip());

    @Override
    public Filters.Filter adapt(FilterAdapterContext context, KeyOnlyFilter filter) throws IOException {
        return KEY_ONLY_FILTER;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, KeyOnlyFilter filter) {
        if (filter.transformCell(TEST_CELL).getValueLength() != 0) {
            return FilterSupportStatus.newNotSupported("KeyOnlyFilters with lenAsVal = true are not supported");
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

