/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TimestampFilterUtil;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import java.util.Iterator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;

@InternalApi(value="For internal usage only")
public class TimestampsFilterAdapter
extends TypedFilterAdapterBase<TimestampsFilter> {
    @Override
    public Filters.Filter adapt(FilterAdapterContext context, TimestampsFilter filter) {
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        Iterator iterator = filter.getTimestamps().iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            interleave.filter(TimestampFilterUtil.hbaseToTimestampRangeFilter(timestamp, timestamp + 1L));
        }
        return interleave;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, TimestampsFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

