/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;

@InternalApi(value="For internal usage only")
public class ValueFilterAdapter
extends TypedFilterAdapterBase<ValueFilter> {
    @Override
    public Filters.Filter adapt(FilterAdapterContext context, ValueFilter filter) throws IOException {
        return this.toFilter(context, filter);
    }

    public Filters.Filter toFilter(FilterAdapterContext context, ValueFilter filter) throws IOException {
        if (filter.getComparator() instanceof BinaryComparator) {
            return this.adaptBinaryComparator(filter.getOperator(), (BinaryComparator)filter.getComparator());
        }
        if (filter.getComparator() instanceof RegexStringComparator) {
            return this.adaptRegexStringComparator(filter.getOperator(), (RegexStringComparator)filter.getComparator());
        }
        throw new IllegalStateException(String.format("Cannot adapt filter with comparator%s", filter.getComparator()));
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, ValueFilter filter) {
        if (filter.getComparator() instanceof BinaryComparator || filter.getComparator() instanceof RegexStringComparator && filter.getOperator() == CompareFilter.CompareOp.EQUAL) {
            return FilterSupportStatus.SUPPORTED;
        }
        return FilterSupportStatus.newNotSupported(String.format("ValueFilter must have either a BinaryComparator with any compareOp or a RegexStringComparator with an EQUAL compareOp. Found (%s, %s)", filter.getComparator().getClass().getSimpleName(), filter.getOperator()));
    }

    private Filters.Filter adaptBinaryComparator(CompareFilter.CompareOp compareOp, BinaryComparator comparator) {
        ByteString value = ByteString.copyFrom((byte[])comparator.getValue());
        switch (compareOp) {
            case LESS: {
                return (Filters.Filter)ValueFilterAdapter.range().endOpen(value);
            }
            case LESS_OR_EQUAL: {
                return (Filters.Filter)ValueFilterAdapter.range().endClosed(value);
            }
            case EQUAL: {
                if (comparator.getValue().length == 0) {
                    return Filters.FILTERS.value().regex(value);
                }
                return (Filters.Filter)((Filters.ValueRangeFilter)ValueFilterAdapter.range().startClosed(value)).endClosed(value);
            }
            case NOT_EQUAL: {
                if (comparator.getValue().length == 0) {
                    return Filters.FILTERS.value().regex("\\C+");
                }
                return Filters.FILTERS.interleave().filter((Filters.Filter)ValueFilterAdapter.range().endOpen(value)).filter((Filters.Filter)ValueFilterAdapter.range().startOpen(value));
            }
            case GREATER_OR_EQUAL: {
                return (Filters.Filter)ValueFilterAdapter.range().startClosed(value);
            }
            case GREATER: {
                return (Filters.Filter)ValueFilterAdapter.range().startOpen(value);
            }
            case NO_OP: {
                return Filters.FILTERS.block();
            }
        }
        throw new IllegalStateException(String.format("Cannot handle unknown compare op %s", compareOp));
    }

    private static Filters.ValueRangeFilter range() {
        return Filters.FILTERS.value().range();
    }

    private Filters.Filter adaptRegexStringComparator(CompareFilter.CompareOp compareOp, RegexStringComparator comparator) {
        String pattern = FilterAdapterHelper.extractRegexPattern(comparator);
        switch (compareOp) {
            case EQUAL: {
                return Filters.FILTERS.value().regex(pattern);
            }
            case NO_OP: {
                return Filters.FILTERS.block();
            }
        }
        throw new IllegalStateException(String.format("Cannot adapt regex filter with compare op %s", compareOp));
    }
}

