/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.util;

import com.google.api.core.InternalApi;
import com.google.protobuf.ByteString;

@InternalApi(value="For internal usage only")
public class RowKeyWrapper
implements Comparable<RowKeyWrapper> {
    private final ByteString key;

    public RowKeyWrapper(ByteString key) {
        this.key = key;
    }

    public ByteString getKey() {
        return this.key;
    }

    @Override
    public int compareTo(RowKeyWrapper o) {
        return this.compare(this.key, o.key);
    }

    private int compare(ByteString key1, ByteString key2) {
        if (key1 == null) {
            if (key2 == null) {
                return 0;
            }
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        if (key1 == key2) {
            return 0;
        }
        int size = Math.min(key1.size(), key2.size());
        for (int i = 0; i < size; ++i) {
            int byte2;
            int byte1 = key1.byteAt(i) & 0xFF;
            int comparison = Integer.compare(byte1, byte2 = key2.byteAt(i) & 0xFF);
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.compare(key1.size(), key2.size());
    }

    public String toString() {
        return this.key.toString();
    }
}

