/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.util;

import com.google.api.core.InternalApi;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.nio.ByteBuffer;

@InternalApi(value="For internal usage only")
public final class ZeroCopyByteStringUtil {
    public static ByteString wrap(byte[] array) {
        return UnsafeByteOperations.unsafeWrap((byte[])array);
    }

    public static byte[] get(ByteString byteString) {
        try {
            ZeroCopyByteOutput byteOutput = new ZeroCopyByteOutput();
            UnsafeByteOperations.unsafeWriteTo((ByteString)byteString, (ByteOutput)byteOutput);
            return byteOutput.bytes;
        }
        catch (IOException e) {
            return byteString.toByteArray();
        }
    }

    private static final class ZeroCopyByteOutput
    extends ByteOutput {
        private byte[] bytes;

        private ZeroCopyByteOutput() {
        }

        public void writeLazy(byte[] value, int offset, int length) {
            if (offset != 0 || length != value.length) {
                throw new UnsupportedOperationException();
            }
            if (this.bytes == null) {
                this.bytes = value;
            } else {
                byte[] newBytes = new byte[this.bytes.length + value.length];
                System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
                System.arraycopy(value, 0, newBytes, this.bytes.length, value.length);
                this.bytes = newBytes;
            }
        }

        public void write(byte value) {
            throw new UnsupportedOperationException();
        }

        public void write(byte[] value, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void write(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }

        public void writeLazy(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }
    }
}

