/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoredTableResult;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.hbase.wrappers.AdminClientWrapper;
import com.google.protobuf.ByteString;
import java.util.List;

@InternalApi(value="For internal usage only")
public class AdminClientVeneerApi
implements AdminClientWrapper {
    private final BigtableTableAdminClient delegate;
    private final BigtableInstanceAdminClient instanceDelegate;

    AdminClientVeneerApi(BigtableTableAdminClient delegate, BigtableInstanceAdminClient instanceDelegate) {
        this.delegate = delegate;
        this.instanceDelegate = instanceDelegate;
    }

    @Override
    public ApiFuture<Table> createTableAsync(CreateTableRequest request) {
        return this.delegate.createTableAsync(request);
    }

    @Override
    public ApiFuture<Table> getTableAsync(String tableId) {
        return this.delegate.getTableAsync(tableId);
    }

    @Override
    public ApiFuture<List<String>> listTablesAsync() {
        return this.delegate.listTablesAsync();
    }

    @Override
    public ApiFuture<Void> deleteTableAsync(String tableId) {
        return this.delegate.deleteTableAsync(tableId);
    }

    @Override
    public ApiFuture<Table> modifyFamiliesAsync(ModifyColumnFamiliesRequest request) {
        return this.delegate.modifyFamiliesAsync(request);
    }

    @Override
    public ApiFuture<Void> dropRowRangeAsync(String tableId, ByteString rowKeyPrefix) {
        return this.delegate.dropRowRangeAsync(tableId, rowKeyPrefix);
    }

    @Override
    public ApiFuture<Void> dropAllRowsAsync(String tableId) {
        return this.delegate.dropAllRowsAsync(tableId);
    }

    @Override
    public ApiFuture<Backup> createBackupAsync(CreateBackupRequest request) {
        return this.delegate.createBackupAsync(request);
    }

    @Override
    public ApiFuture<List<String>> listBackupsAsync(String clusterId) {
        return this.delegate.listBackupsAsync(clusterId);
    }

    @Override
    public ApiFuture<Void> deleteBackupAsync(String clusterId, String backupId) {
        return this.delegate.deleteBackupAsync(clusterId, backupId);
    }

    @Override
    public ApiFuture<RestoredTableResult> restoreTableAsync(RestoreTableRequest request) {
        return this.delegate.restoreTableAsync(request);
    }

    @Override
    public List<Cluster> listClusters(String instanceId) {
        return this.instanceDelegate.listClusters(instanceId);
    }

    @Override
    public void close() {
        this.delegate.close();
        if (this.instanceDelegate != null) {
            this.instanceDelegate.close();
        }
    }
}

