/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.hbase.wrappers.AdminClientWrapper;
import com.google.cloud.bigtable.hbase.wrappers.BigtableApi;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import com.google.cloud.bigtable.hbase.wrappers.veneer.AdminClientVeneerApi;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableHBaseVeneerSettings;
import com.google.cloud.bigtable.hbase.wrappers.veneer.DataClientVeneerApi;
import com.google.cloud.bigtable.hbase.wrappers.veneer.SharedDataClientWrapperFactory;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Counter;
import java.io.IOException;

@InternalApi(value="For internal usage only")
public class BigtableVeneerApi
extends BigtableApi {
    private final Counter activeSessions = BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"session.active");
    private static final SharedDataClientWrapperFactory sharedClientFactory = new SharedDataClientWrapperFactory();
    private final DataClientWrapper dataClientWrapper;
    private final AdminClientWrapper adminClientWrapper;
    private final int channelPoolSize;

    public BigtableVeneerApi(BigtableHBaseVeneerSettings settings) throws IOException {
        super(settings);
        if (settings.isChannelPoolCachingEnabled()) {
            this.dataClientWrapper = sharedClientFactory.createDataClient(settings);
            this.channelPoolSize = 0;
        } else {
            this.dataClientWrapper = new DataClientVeneerApi(BigtableDataClient.create((BigtableDataSettings)settings.getDataSettings()), settings.getClientTimeouts());
            this.channelPoolSize = BigtableVeneerApi.getChannelPoolSize(settings.getDataSettings().getStubSettings());
            for (int i = 0; i < this.channelPoolSize; ++i) {
                BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.channel.active").inc();
            }
        }
        BigtableInstanceAdminSettings instanceAdminSettings = settings.getInstanceAdminSettings();
        this.adminClientWrapper = new AdminClientVeneerApi(BigtableTableAdminClient.create((BigtableTableAdminSettings)settings.getTableAdminSettings()), BigtableInstanceAdminClient.create((BigtableInstanceAdminSettings)instanceAdminSettings));
        this.activeSessions.inc();
    }

    @Override
    public AdminClientWrapper getAdminClient() {
        return this.adminClientWrapper;
    }

    @Override
    public DataClientWrapper getDataClient() {
        return this.dataClientWrapper;
    }

    @Override
    public void close() throws IOException {
        this.dataClientWrapper.close();
        this.adminClientWrapper.close();
        this.activeSessions.dec();
        for (int i = 0; i < this.channelPoolSize; ++i) {
            BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.channel.active").dec();
        }
    }

    static int getChannelPoolSize(EnhancedBigtableStubSettings stubSettings) {
        if (stubSettings.getTransportChannelProvider() instanceof InstantiatingGrpcChannelProvider) {
            InstantiatingGrpcChannelProvider channelProvider = (InstantiatingGrpcChannelProvider)stubSettings.getTransportChannelProvider();
            return channelProvider.toBuilder().getPoolSize();
        }
        return 0;
    }
}

