/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.wrappers.BulkMutationWrapper;
import com.google.cloud.bigtable.hbase.wrappers.BulkReadWrapper;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableHBaseVeneerSettings;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BulkMutationVeneerApi;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BulkReadVeneerApi;
import com.google.cloud.bigtable.hbase.wrappers.veneer.RowResultAdapter;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.Timer;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import io.grpc.CallOptions;
import io.grpc.Deadline;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.threeten.bp.Duration;

@InternalApi(value="For internal usage only")
public class DataClientVeneerApi
implements DataClientWrapper {
    private static final RowResultAdapter RESULT_ADAPTER = new RowResultAdapter();
    private final BigtableDataClient delegate;
    private final BigtableHBaseVeneerSettings.ClientOperationTimeouts clientOperationTimeouts;

    DataClientVeneerApi(BigtableDataClient delegate, BigtableHBaseVeneerSettings.ClientOperationTimeouts clientOperationTimeouts) {
        this.delegate = delegate;
        this.clientOperationTimeouts = clientOperationTimeouts;
    }

    @Override
    public BulkMutationWrapper createBulkMutation(String tableId) {
        return new BulkMutationVeneerApi((Batcher<RowMutationEntry, Void>)this.delegate.newBulkMutationBatcher(tableId), 0L);
    }

    @Override
    public BulkMutationWrapper createBulkMutation(String tableId, long closeTimeoutMilliseconds) {
        return new BulkMutationVeneerApi((Batcher<RowMutationEntry, Void>)this.delegate.newBulkMutationBatcher(tableId), closeTimeoutMilliseconds);
    }

    @Override
    public BulkReadWrapper createBulkRead(String tableId) {
        return new BulkReadVeneerApi(this.delegate, tableId, this.createScanCallContext());
    }

    @Override
    public ApiFuture<Void> mutateRowAsync(RowMutation rowMutation) {
        return this.delegate.mutateRowAsync(rowMutation);
    }

    @Override
    public ApiFuture<Result> readModifyWriteRowAsync(ReadModifyWriteRow readModifyWriteRow) {
        return ApiFutures.transform((ApiFuture)this.delegate.readModifyWriteRowAsync(readModifyWriteRow), (ApiFunction)new ApiFunction<Row, Result>(){

            public Result apply(Row row) {
                return Adapters.ROW_ADAPTER.adaptResponse(row);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<Boolean> checkAndMutateRowAsync(ConditionalRowMutation conditionalRowMutation) {
        return this.delegate.checkAndMutateRowAsync(conditionalRowMutation);
    }

    @Override
    public ApiFuture<List<KeyOffset>> sampleRowKeysAsync(String tableId) {
        return this.delegate.sampleRowKeysAsync(tableId);
    }

    @Override
    public ApiFuture<Result> readRowAsync(String tableId, ByteString rowKey, @Nullable Filters.Filter filter) {
        Query query = Query.create((String)tableId).rowKey(rowKey).limit(1L);
        if (filter != null) {
            query.filter(filter);
        }
        return ApiFutures.transform((ApiFuture)this.delegate.readRowCallable().futureCall((Object)query, this.createReadRowCallContext()), (ApiFunction)new ApiFunction<Row, Result>(){

            public Result apply(Row row) {
                return Adapters.ROW_ADAPTER.adaptResponse(row);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ResultScanner readRows(Query.QueryPaginator paginator, long maxSegmentByteSize) {
        return new PaginatedRowResultScanner(paginator, this.delegate, maxSegmentByteSize, this.createScanCallContext());
    }

    @Override
    public ResultScanner readRows(Query request) {
        return new RowResultScanner((ServerStream<Result>)this.delegate.readRowsCallable((RowAdapter)RESULT_ADAPTER).call((Object)request, (ApiCallContext)this.createScanCallContext()));
    }

    @Override
    public ApiFuture<List<Result>> readRowsAsync(Query request) {
        return this.delegate.readRowsCallable((RowAdapter)RESULT_ADAPTER).all().futureCall((Object)request, (ApiCallContext)this.createScanCallContext());
    }

    @Override
    public void readRowsAsync(Query request, ResponseObserver<Result> observer) {
        this.delegate.readRowsCallable((RowAdapter)RESULT_ADAPTER).call((Object)request, observer, (ApiCallContext)this.createScanCallContext());
    }

    private ApiCallContext createReadRowCallContext() {
        GrpcCallContext ctx = GrpcCallContext.createDefault();
        BigtableHBaseVeneerSettings.OperationTimeouts callSettings = this.clientOperationTimeouts.getUnaryTimeouts();
        if (callSettings.getAttemptTimeout().isPresent()) {
            ctx = ctx.withTimeout((Duration)callSettings.getAttemptTimeout().get());
        }
        if (callSettings.getOperationTimeout().isPresent()) {
            ctx = ctx.withCallOptions(CallOptions.DEFAULT.withDeadline(Deadline.after((long)((Duration)callSettings.getOperationTimeout().get()).toMillis(), (TimeUnit)TimeUnit.MILLISECONDS)));
        }
        return ctx;
    }

    private GrpcCallContext createScanCallContext() {
        GrpcCallContext ctx = GrpcCallContext.createDefault();
        BigtableHBaseVeneerSettings.OperationTimeouts callSettings = this.clientOperationTimeouts.getScanTimeouts();
        if (callSettings.getOperationTimeout().isPresent()) {
            ctx = ctx.withCallOptions(CallOptions.DEFAULT.withDeadline(Deadline.after((long)((Duration)callSettings.getOperationTimeout().get()).toMillis(), (TimeUnit)TimeUnit.MILLISECONDS)));
        }
        if (callSettings.getAttemptTimeout().isPresent()) {
            ctx = ctx.withTimeout((Duration)callSettings.getAttemptTimeout().get());
        }
        return ctx;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private static class RowResultScanner
    extends AbstractClientScanner {
        private final Meter scannerResultMeter = BigtableClientMetrics.meter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"scanner.results");
        private final Timer scannerResultTimer = BigtableClientMetrics.timer((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Debug, (String)"scanner.results.latency");
        private final ServerStream<Result> serverStream;
        private final Iterator<Result> iterator;

        RowResultScanner(ServerStream<Result> serverStream) {
            this.serverStream = serverStream;
            this.iterator = serverStream.iterator();
        }

        public Result next() {
            try (Timer.Context ignored = this.scannerResultTimer.time();){
                if (!this.iterator.hasNext()) {
                    Result result = null;
                    return result;
                }
                this.scannerResultMeter.mark();
                Result result = this.iterator.next();
                return result;
            }
        }

        public void close() {
            this.serverStream.cancel();
        }

        public boolean renewLease() {
            return true;
        }
    }

    static class PaginatedRowResultScanner
    extends AbstractClientScanner {
        private static final double WATERMARK_PERCENTAGE = 0.1;
        private static final RowResultAdapter RESULT_ADAPTER = new RowResultAdapter();
        private final Meter scannerResultMeter = BigtableClientMetrics.meter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"scanner.results");
        private final Timer scannerResultTimer = BigtableClientMetrics.timer((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Debug, (String)"scanner.results.latency");
        private ByteString lastSeenRowKey = ByteString.EMPTY;
        private Boolean hasMore = true;
        private final Queue<Result> buffer;
        private final Query.QueryPaginator paginator;
        private final int refillSegmentWaterMark;
        private final BigtableDataClient dataClient;
        private final long maxSegmentByteSize;
        private long currentByteSize = 0L;
        @Nullable
        private Future<List<Result>> future;
        private GrpcCallContext scanCallContext;

        PaginatedRowResultScanner(Query.QueryPaginator paginator, BigtableDataClient dataClient, long maxSegmentByteSize, GrpcCallContext scanCallContext) {
            this.maxSegmentByteSize = maxSegmentByteSize;
            this.paginator = paginator;
            this.dataClient = dataClient;
            this.buffer = new ArrayDeque<Result>();
            this.refillSegmentWaterMark = (int)Math.max(1.0, (double)paginator.getPageSize() * 0.1);
            this.scanCallContext = scanCallContext;
            this.future = this.fetchNextSegment();
        }

        public Result next() {
            try (Timer.Context ignored = this.scannerResultTimer.time();){
                Result result;
                if (this.future != null && this.future.isDone()) {
                    this.consumeReadRowsFuture();
                }
                if (this.buffer.size() < this.refillSegmentWaterMark && this.future == null && this.hasMore.booleanValue()) {
                    this.future = this.fetchNextSegment();
                }
                if (this.buffer.isEmpty() && this.future != null) {
                    this.consumeReadRowsFuture();
                }
                if ((result = this.buffer.poll()) != null) {
                    this.scannerResultMeter.mark();
                    this.currentByteSize -= Result.getTotalSizeOfCells((Result)result);
                }
                Result result2 = result;
                return result2;
            }
        }

        public void close() {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }

        public boolean renewLease() {
            return true;
        }

        private Future<List<Result>> fetchNextSegment() {
            final SettableFuture resultsFuture = SettableFuture.create();
            this.dataClient.readRowsCallable((RowAdapter)RESULT_ADAPTER).call((Object)this.paginator.getNextQuery(), (ResponseObserver)new ResponseObserver<Result>(){
                private StreamController controller;
                List<Result> results = new ArrayList<Result>();

                public void onStart(StreamController controller) {
                    this.controller = controller;
                }

                public void onResponse(Result result) {
                    currentByteSize = currentByteSize + Result.getTotalSizeOfCells((Result)result);
                    this.results.add(result);
                    if (result != null && result.rawCells() != null) {
                        lastSeenRowKey = RESULT_ADAPTER.getKey(result);
                    }
                    if (currentByteSize > maxSegmentByteSize) {
                        this.controller.cancel();
                        return;
                    }
                }

                public void onError(Throwable t) {
                    if (currentByteSize > maxSegmentByteSize) {
                        this.onComplete();
                    } else {
                        resultsFuture.setException(t);
                    }
                }

                public void onComplete() {
                    resultsFuture.set(this.results);
                }
            }, (ApiCallContext)this.scanCallContext);
            return resultsFuture;
        }

        private void consumeReadRowsFuture() {
            try {
                List<Result> results = this.future.get();
                this.buffer.addAll(results);
                this.hasMore = this.paginator.advance(this.lastSeenRowKey);
                this.future = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }
}

