/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer.metrics;

import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.BaseApiTracer;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Counter;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.RpcMetrics;
import com.google.cloud.bigtable.metrics.Timer;
import io.grpc.Status;
import java.util.concurrent.atomic.AtomicBoolean;
import org.threeten.bp.Duration;

@InternalApi
public class MetricsApiTracerAdapter
extends BaseApiTracer {
    private final Timer firstResponseLatencyTimer = BigtableClientMetrics.timer((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.method.ReadRows.firstResponse.latency");
    private final Counter activeRpcCounter = BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.rpc.active");
    private final Meter rpcMeter = BigtableClientMetrics.meter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.rpc.performed");
    private final RpcMetrics rpcMetrics;
    private final Timer.Context operationTimer;
    private volatile Timer.Context rpcTimer;
    private volatile RetryStatus lastRetryStatus;
    private final AtomicBoolean firstResponseRecorded;
    private volatile Timer.Context firstResponseTimer;

    public MetricsApiTracerAdapter(RpcMetrics rpcMetrics, String methodName, ApiTracerFactory.OperationType operationType) {
        this.rpcMetrics = rpcMetrics;
        this.operationTimer = rpcMetrics.timeOperation();
        this.lastRetryStatus = RetryStatus.PERMANENT_FAILURE;
        if (methodName.equals("ReadRows") && operationType == ApiTracerFactory.OperationType.ServerStreaming) {
            this.firstResponseTimer = this.firstResponseLatencyTimer.time();
        }
        this.firstResponseRecorded = new AtomicBoolean(false);
    }

    public ApiTracer.Scope inScope() {
        return new ApiTracer.Scope(){

            public void close() {
            }
        };
    }

    public void operationSucceeded() {
        this.operationTimer.close();
    }

    public void operationCancelled() {
        this.operationTimer.close();
    }

    public void operationFailed(Throwable error) {
        if (this.lastRetryStatus == RetryStatus.RETRIES_EXHAUSTED) {
            this.rpcMetrics.markRetriesExhasted();
        } else {
            this.rpcMetrics.markFailure();
        }
        this.operationTimer.close();
    }

    public void connectionSelected(String id) {
    }

    public void attemptStarted(int attemptNumber) {
        this.lastRetryStatus = RetryStatus.PERMANENT_FAILURE;
        this.rpcTimer = this.rpcMetrics.timeRpc();
        this.activeRpcCounter.inc();
        this.rpcMeter.mark();
    }

    public void attemptSucceeded() {
        this.rpcTimer.close();
        this.activeRpcCounter.dec();
    }

    public void attemptCancelled() {
        this.rpcTimer.close();
        this.activeRpcCounter.dec();
    }

    public void attemptFailed(Throwable error, Duration delay) {
        this.rpcTimer.close();
        this.lastRetryStatus = RetryStatus.ATTEMPT_RETRYABLE_FAILURE;
        this.rpcMetrics.markRetry();
        this.activeRpcCounter.dec();
        BigtableClientMetrics.meter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)("grpc.errors." + Status.fromThrowable((Throwable)error).getCode())).mark();
    }

    public void attemptFailedRetriesExhausted(Throwable error) {
        this.rpcTimer.close();
        this.activeRpcCounter.dec();
        this.lastRetryStatus = RetryStatus.RETRIES_EXHAUSTED;
    }

    public void attemptPermanentFailure(Throwable error) {
        this.rpcTimer.close();
        this.activeRpcCounter.dec();
        this.lastRetryStatus = RetryStatus.PERMANENT_FAILURE;
    }

    public void lroStartFailed(Throwable error) {
    }

    public void lroStartSucceeded() {
    }

    public void responseReceived() {
        if (this.firstResponseTimer != null && this.firstResponseRecorded.compareAndSet(false, true)) {
            this.firstResponseTimer.close();
        }
    }

    public void requestSent() {
    }

    public void batchRequestSent(long elementCount, long requestSize) {
    }

    private static enum RetryStatus {
        PERMANENT_FAILURE,
        RETRIES_EXHAUSTED,
        ATTEMPT_RETRYABLE_FAILURE;

    }
}

