/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableCredentialsWrapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public abstract class BigtableOAuth2Credentials {
    public BigtableOAuth2Credentials(Configuration configuration) {
    }

    public abstract Map<String, List<String>> getRequestMetadata(URI var1) throws IOException;

    @InternalApi(value="For internal usage only")
    public static Credentials newInstance(Class<? extends BigtableOAuth2Credentials> bigtableAuthClass, Configuration conf) {
        Constructor<? extends BigtableOAuth2Credentials> constructor = null;
        try {
            constructor = bigtableAuthClass.getConstructor(Configuration.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Custom credentials class [" + bigtableAuthClass + "] must implement a constructor with single argument of type " + Configuration.class.getName() + ".", e);
        }
        try {
            return new BigtableCredentialsWrapper(constructor.newInstance(conf));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create object of custom Credentials class [" + bigtableAuthClass.getName() + "].", e);
        }
    }
}

