/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.cloud.bigtable.hbase.filter.TimestampRangeFilter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.ValueFilter;

@InternalApi(value="For internal usage only")
public class CheckAndMutateUtil {
    private static final ReadHooks UNSUPPORTED_READ_HOOKS = new ReadHooks(){

        @Override
        public void composePreSendHook(Function<Query, Query> newHook) {
            throw new IllegalStateException("We built a bad Filter for conditional mutation.");
        }

        @Override
        public void applyPreSendHook(Query query) {
            throw new UnsupportedOperationException("We built a bad Filter for conditional mutation.");
        }
    };

    public static boolean wasMutationApplied(ConditionalRowMutation request, Boolean predicateMatched) {
        CheckAndMutateRowRequest proto = request.toProto(RequestContext.create((String)"SomeProject", (String)"Some Instance", (String)""));
        return proto.getTrueMutationsCount() > 0 && predicateMatched != false || proto.getFalseMutationsCount() > 0 && predicateMatched == false;
    }

    private static CompareFilter.CompareOp reverseCompareOp(CompareFilter.CompareOp compareOp) {
        switch (compareOp) {
            case EQUAL: 
            case NOT_EQUAL: 
            case NO_OP: {
                return compareOp;
            }
            case LESS: {
                return CompareFilter.CompareOp.GREATER;
            }
            case LESS_OR_EQUAL: {
                return CompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return CompareFilter.CompareOp.LESS;
            }
            case GREATER_OR_EQUAL: {
                return CompareFilter.CompareOp.LESS_OR_EQUAL;
            }
        }
        return CompareFilter.CompareOp.NO_OP;
    }

    public static class RequestBuilder {
        private final HBaseRequestAdapter hbaseAdapter;
        private final Mutation mutations = Mutation.createUnsafe();
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private CompareFilter.CompareOp compareOp;
        private byte[] value;
        private boolean checkNonExistence = false;
        private Filter timeFilter = null;

        public RequestBuilder(HBaseRequestAdapter hbaseAdapter, byte[] row, byte[] family) {
            this.row = (byte[])Preconditions.checkNotNull((Object)row, (Object)"row is null");
            this.family = (byte[])Preconditions.checkNotNull((Object)family, (Object)"family is null");
            this.hbaseAdapter = hbaseAdapter.withServerSideTimestamps();
        }

        public RequestBuilder qualifier(byte[] qualifier) {
            this.qualifier = (byte[])Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier is null. Consider using an empty byte array, or just do not call this method if you want a null qualifier");
            return this;
        }

        public RequestBuilder ifNotExists() {
            Preconditions.checkState((this.compareOp == null ? 1 : 0) != 0, (Object)"ifNotExists and ifMatches are mutually exclusive");
            this.checkNonExistence = true;
            return this;
        }

        public RequestBuilder ifMatches(CompareFilter.CompareOp compareOp, @Nullable byte[] value) {
            Preconditions.checkState((!this.checkNonExistence ? 1 : 0) != 0, (Object)"ifNotExists and ifMatches are mutually exclusive");
            this.compareOp = (CompareFilter.CompareOp)Preconditions.checkNotNull((Object)compareOp, (Object)"compareOp is null");
            this.value = value;
            return this;
        }

        public RequestBuilder timeRange(long start, long end) {
            if (start == 0L && end == Long.MAX_VALUE) {
                return this;
            }
            Preconditions.checkArgument((0L <= start && start < end ? 1 : 0) != 0, (Object)"Invalid start/end");
            this.timeFilter = new TimestampRangeFilter(start, end);
            return this;
        }

        public RequestBuilder withPut(Put put) throws DoNotRetryIOException {
            this.validateRow(put.getRow());
            this.hbaseAdapter.adapt(put, (MutationApi<?>)this.mutations);
            return this;
        }

        public RequestBuilder withDelete(Delete delete) throws DoNotRetryIOException {
            this.validateRow(delete.getRow());
            this.hbaseAdapter.adapt(delete, (MutationApi<?>)this.mutations);
            return this;
        }

        public RequestBuilder withMutations(RowMutations rm) throws DoNotRetryIOException {
            this.validateRow(rm.getRow());
            this.hbaseAdapter.adapt(rm, (MutationApi<?>)this.mutations);
            return this;
        }

        private void validateRow(byte[] actionRow) throws DoNotRetryIOException {
            if (!Arrays.equals(actionRow, this.row)) {
                throw new DoNotRetryIOException("Action's getRow must match the passed row");
            }
        }

        public ConditionalRowMutation build() {
            Preconditions.checkState((this.checkNonExistence || this.compareOp != null ? 1 : 0) != 0, (Object)"condition is null. You need to specify the condition by calling ifNotExists/ifEquals/ifMatches before executing the request");
            ConditionalRowMutation conditionalRowMutation = ConditionalRowMutation.create((String)this.hbaseAdapter.getTableId(), (ByteString)ByteString.copyFrom((byte[])this.row));
            Scan scan = new Scan();
            scan.setMaxVersions(1);
            scan.addColumn(this.family, this.qualifier);
            if (this.value == null || this.value.length == 0 || this.checkNonExistence) {
                if (CompareFilter.CompareOp.NOT_EQUAL.equals((Object)this.compareOp)) {
                    conditionalRowMutation.then(this.mutations);
                } else {
                    conditionalRowMutation.otherwise(this.mutations);
                }
                if (this.timeFilter != null) {
                    scan.setFilter(this.timeFilter);
                }
            } else {
                ValueFilter valueFilter = new ValueFilter(CheckAndMutateUtil.reverseCompareOp(this.compareOp), (ByteArrayComparable)new BinaryComparator(this.value));
                if (this.timeFilter != null) {
                    scan.setFilter((Filter)new FilterList(new Filter[]{this.timeFilter, valueFilter}));
                } else {
                    scan.setFilter((Filter)valueFilter);
                }
                conditionalRowMutation.then(this.mutations);
            }
            conditionalRowMutation.condition(Adapters.SCAN_ADAPTER.buildFilter(scan, UNSUPPORTED_READ_HOOKS));
            return conditionalRowMutation;
        }
    }
}

