/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.util.RowKeyWrapper;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;

@InternalApi(value="For internal usage only")
public class MultiRowRangeFilterAdapter
extends TypedFilterAdapterBase<MultiRowRangeFilter> {
    private static final FilterSupportStatus NO_MUST_PASS_ONE = FilterSupportStatus.newNotSupported("MultiRowRange filters can not be contained in MUST_PASS_ONE FilterLists");

    @Override
    public Filters.Filter adapt(FilterAdapterContext context, MultiRowRangeFilter filter) throws IOException {
        return Filters.FILTERS.pass();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, MultiRowRangeFilter filter) {
        for (FilterList filterList : context.getCurrentFilterLists()) {
            if (filterList.getOperator() != FilterList.Operator.MUST_PASS_ONE) continue;
            return NO_MUST_PASS_ONE;
        }
        return FilterSupportStatus.SUPPORTED;
    }

    @Override
    public RangeSet<RowKeyWrapper> getIndexScanHint(MultiRowRangeFilter filter) {
        ImmutableRangeSet.Builder rangeSetBuilder = ImmutableRangeSet.builder();
        for (MultiRowRangeFilter.RowRange rowRange : filter.getRowRanges()) {
            rangeSetBuilder.add(this.rowRangeToRange(rowRange));
        }
        return rangeSetBuilder.build();
    }

    private Range<RowKeyWrapper> rowRangeToRange(MultiRowRangeFilter.RowRange rowRange) {
        BoundType stopboundType;
        boolean startUnbounded = HConstants.EMPTY_BYTE_ARRAY.equals(rowRange.getStartRow());
        RowKeyWrapper start = new RowKeyWrapper(ByteString.copyFrom((byte[])rowRange.getStartRow()));
        BoundType startboundType = rowRange.isStartRowInclusive() ? BoundType.CLOSED : BoundType.OPEN;
        boolean stopUnbounded = HConstants.EMPTY_BYTE_ARRAY.equals(rowRange.getStopRow());
        RowKeyWrapper stop = new RowKeyWrapper(ByteString.copyFrom((byte[])rowRange.getStopRow()));
        BoundType boundType = stopboundType = rowRange.isStopRowInclusive() ? BoundType.CLOSED : BoundType.OPEN;
        if (startUnbounded && stopUnbounded) {
            return Range.all();
        }
        if (startUnbounded) {
            return Range.upTo((Comparable)stop, (BoundType)stopboundType);
        }
        if (stopUnbounded) {
            return Range.downTo((Comparable)start, (BoundType)startboundType);
        }
        return Range.range((Comparable)start, (BoundType)startboundType, (Comparable)stop, (BoundType)stopboundType);
    }
}

