/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;

@InternalApi(value="For internal usage only")
public class MultipleColumnPrefixFilterAdapter
extends TypedFilterAdapterBase<MultipleColumnPrefixFilter> {
    @Override
    public Filters.Filter adapt(FilterAdapterContext context, MultipleColumnPrefixFilter filter) throws IOException {
        Filters.InterleaveFilter interleave = Filters.FILTERS.interleave();
        ByteString.Output outputStream = null;
        for (byte[] prefix : filter.getPrefix()) {
            if (outputStream == null) {
                outputStream = ByteString.newOutput((int)(prefix.length * 2));
            } else {
                outputStream.reset();
            }
            ReaderExpressionHelper.writeQuotedExpression(outputStream, prefix);
            outputStream.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
            interleave.filter(Filters.FILTERS.qualifier().regex(outputStream.toByteString()));
        }
        return interleave;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, MultipleColumnPrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

