/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.api.core.InternalApi;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class ReaderExpressionHelper {
    public static final String ANY_BYTE = "\\C";
    public static final String ANY_BYTES = "\\C+";
    public static final String ALL_BYTES = "\\C*";
    public static final byte[] ANY_BYTE_BYTES = Bytes.toBytes((String)"\\C");
    public static final byte[] ALL_BYTE_BYTES = Bytes.toBytes((String)"\\C*");
    public static final byte[] ALL_QUALIFIERS_BYTES = ALL_BYTE_BYTES;
    private static final byte[] NULL_CHARACTER_BYTES = Bytes.toBytes((String)"\\x00");

    public static void writeQuotedExpression(OutputStream outputStream, byte[] unquoted) throws IOException {
        ReaderExpressionHelper.writeQuotedRegularExpression(new QuoteFilterExpressionStream(outputStream), unquoted);
    }

    public static ByteString quoteRegularExpression(byte[] unquoted) throws IOException {
        ByteString.Output output = ByteString.newOutput((int)(unquoted.length * 2));
        ReaderExpressionHelper.writeQuotedRegularExpression((OutputStream)output, unquoted);
        return output.toByteString();
    }

    public static void writeQuotedRegularExpression(OutputStream outputStream, byte[] unquoted) throws IOException {
        QuoteMetaOutputStream quoteMetaOutputStream = new QuoteMetaOutputStream(outputStream);
        quoteMetaOutputStream.write(unquoted);
        quoteMetaOutputStream.close();
    }

    public static class QuoteFilterExpressionStream
    extends OutputStream {
        protected final OutputStream delegate;

        public QuoteFilterExpressionStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int unquoted) throws IOException {
            switch (unquoted) {
                case 64: 
                case 123: 
                case 125: {
                    this.delegate.write(64);
                }
            }
            this.delegate.write(unquoted);
        }
    }

    public static class QuoteMetaOutputStream
    extends OutputStream {
        protected final OutputStream delegate;

        public QuoteMetaOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        public void writeNullCharacterBytes() throws IOException {
            for (byte b : NULL_CHARACTER_BYTES) {
                this.delegate.write(b);
            }
        }

        @Override
        public void write(int unquoted) throws IOException {
            if (unquoted == 0) {
                this.writeNullCharacterBytes();
                return;
            }
            if (!(unquoted >= 97 && unquoted <= 122 || unquoted >= 65 && unquoted <= 90 || unquoted >= 48 && unquoted <= 57 || unquoted == 95 || unquoted < 0)) {
                this.delegate.write(92);
            }
            this.delegate.write(unquoted);
        }
    }
}

