/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.util;

import com.google.api.core.InternalApi;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

@InternalApi
public class FutureUtil {
    public static <T> T unwrap(Future<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw FutureUtil.rethrow(e.getCause());
        }
    }

    private static IOException rethrow(Throwable error) throws IOException {
        if (error instanceof IOException) {
            FutureUtil.setStackTrace(error);
            throw (IOException)error;
        }
        if (error instanceof RuntimeException) {
            FutureUtil.setStackTrace(error);
            throw (RuntimeException)error;
        }
        if (error instanceof Error) {
            FutureUtil.setStackTrace(error);
            throw (Error)error;
        }
        throw new IOException(error);
    }

    private static void setStackTrace(Throwable error) {
        StackTraceElement[] localStackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] originalStackTrace = error.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[localStackTrace.length + originalStackTrace.length + 1];
        System.arraycopy(localStackTrace, 0, newStackTrace, 0, localStackTrace.length);
        newStackTrace[localStackTrace.length] = new StackTraceElement("--------Future", "get--------", null, -1);
        System.arraycopy(originalStackTrace, 0, newStackTrace, localStackTrace.length + 1, originalStackTrace.length);
        error.setStackTrace(newStackTrace);
    }
}

